/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web;

import com.baidu.cloud.thirdparty.servlet.ServletContainerInitializer;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.annotation.HandlesTypes;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAwareOrderComparator;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ReflectionUtils;
import com.baidu.cloud.thirdparty.springframework.web.WebApplicationInitializer;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Set;

@HandlesTypes(value={WebApplicationInitializer.class})
public class SpringServletContainerInitializer
implements ServletContainerInitializer {
    @Override
    public void onStartup(@Nullable Set<Class<?>> webAppInitializerClasses, ServletContext servletContext) throws ServletException {
        LinkedList<WebApplicationInitializer> initializers = new LinkedList<WebApplicationInitializer>();
        if (webAppInitializerClasses != null) {
            for (Class<?> waiClass : webAppInitializerClasses) {
                if (waiClass.isInterface() || Modifier.isAbstract(waiClass.getModifiers()) || !WebApplicationInitializer.class.isAssignableFrom(waiClass)) continue;
                try {
                    initializers.add((WebApplicationInitializer)ReflectionUtils.accessibleConstructor(waiClass, new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable ex) {
                    throw new ServletException("Failed to instantiate WebApplicationInitializer class", ex);
                }
            }
        }
        if (initializers.isEmpty()) {
            servletContext.log("No Spring WebApplicationInitializer types detected on classpath");
            return;
        }
        servletContext.log(initializers.size() + " Spring WebApplicationInitializers detected on classpath");
        AnnotationAwareOrderComparator.sort(initializers);
        for (WebApplicationInitializer initializer : initializers) {
            initializer.onStartup(servletContext);
        }
    }
}

