/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context.support;

import com.baidu.cloud.thirdparty.servlet.ServletConfig;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.baidu.cloud.thirdparty.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import com.baidu.cloud.thirdparty.springframework.core.env.ConfigurableEnvironment;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.core.io.support.ResourcePatternResolver;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.ui.context.Theme;
import com.baidu.cloud.thirdparty.springframework.ui.context.ThemeSource;
import com.baidu.cloud.thirdparty.springframework.ui.context.support.UiApplicationContextUtils;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.context.ConfigurableWebApplicationContext;
import com.baidu.cloud.thirdparty.springframework.web.context.ConfigurableWebEnvironment;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletConfigAware;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletContextAware;
import com.baidu.cloud.thirdparty.springframework.web.context.support.ServletContextAwareProcessor;
import com.baidu.cloud.thirdparty.springframework.web.context.support.ServletContextResource;
import com.baidu.cloud.thirdparty.springframework.web.context.support.ServletContextResourcePatternResolver;
import com.baidu.cloud.thirdparty.springframework.web.context.support.StandardServletEnvironment;
import com.baidu.cloud.thirdparty.springframework.web.context.support.WebApplicationContextUtils;

public abstract class AbstractRefreshableWebApplicationContext
extends AbstractRefreshableConfigApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    @Nullable
    private ServletContext servletContext;
    @Nullable
    private ServletConfig servletConfig;
    @Nullable
    private String namespace;
    @Nullable
    private ThemeSource themeSource;

    public AbstractRefreshableWebApplicationContext() {
        this.setDisplayName("Root WebApplicationContext");
    }

    @Override
    public void setServletContext(@Nullable ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    @Nullable
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletConfig(@Nullable ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        if (servletConfig != null && this.servletContext == null) {
            this.setServletContext(servletConfig.getServletContext());
        }
    }

    @Override
    @Nullable
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    @Override
    public void setNamespace(@Nullable String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + namespace + "'");
        }
    }

    @Override
    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String[] getConfigLocations() {
        return super.getConfigLocations();
    }

    @Override
    public String getApplicationName() {
        return this.servletContext != null ? this.servletContext.getContextPath() : "";
    }

    @Override
    protected ConfigurableEnvironment createEnvironment() {
        return new StandardServletEnvironment();
    }

    @Override
    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor(new ServletContextAwareProcessor(this.servletContext, this.servletConfig));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
        beanFactory.ignoreDependencyInterface(ServletConfigAware.class);
        WebApplicationContextUtils.registerWebApplicationScopes(beanFactory, this.servletContext);
        WebApplicationContextUtils.registerEnvironmentBeans(beanFactory, this.servletContext, this.servletConfig);
    }

    @Override
    protected Resource getResourceByPath(String path) {
        Assert.state(this.servletContext != null, "No ServletContext available");
        return new ServletContextResource(this.servletContext, path);
    }

    @Override
    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver(this);
    }

    @Override
    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource(this);
    }

    @Override
    protected void initPropertySources() {
        ConfigurableEnvironment env = this.getEnvironment();
        if (env instanceof ConfigurableWebEnvironment) {
            ((ConfigurableWebEnvironment)env).initPropertySources(this.servletContext, this.servletConfig);
        }
    }

    @Override
    @Nullable
    public Theme getTheme(String themeName) {
        Assert.state(this.themeSource != null, "No ThemeSource available");
        return this.themeSource.getTheme(themeName);
    }
}

