/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context.support;

import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.http.HttpServlet;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.context.i18n.LocaleContextHolder;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.HttpRequestHandler;
import com.baidu.cloud.thirdparty.springframework.web.HttpRequestMethodNotSupportedException;
import com.baidu.cloud.thirdparty.springframework.web.context.WebApplicationContext;
import com.baidu.cloud.thirdparty.springframework.web.context.support.WebApplicationContextUtils;
import java.io.IOException;

public class HttpRequestHandlerServlet
extends HttpServlet {
    @Nullable
    private HttpRequestHandler target;

    @Override
    public void init() throws ServletException {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        this.target = wac.getBean(this.getServletName(), HttpRequestHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Assert.state(this.target != null, "No HttpRequestHandler available");
        LocaleContextHolder.setLocale(request.getLocale());
        try {
            this.target.handleRequest(request, response);
        }
        catch (HttpRequestMethodNotSupportedException ex) {
            Object[] supportedMethods = ex.getSupportedMethods();
            if (supportedMethods != null) {
                response.setHeader("Allow", StringUtils.arrayToDelimitedString(supportedMethods, ", "));
            }
            response.sendError(405, ex.getMessage());
        }
        finally {
            LocaleContextHolder.resetLocaleContext();
        }
    }
}

