/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context.support;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletContextAware;
import java.util.Map;

public class ServletContextAttributeExporter
implements ServletContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private Map<String, Object> attributes;

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        if (this.attributes != null) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                String attributeName = entry.getKey();
                if (this.logger.isWarnEnabled() && servletContext.getAttribute(attributeName) != null) {
                    this.logger.warn("Replacing existing ServletContext attribute with name '" + attributeName + "'");
                }
                servletContext.setAttribute(attributeName, entry.getValue());
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Exported ServletContext attribute with name '" + attributeName + "'");
            }
        }
    }
}

