/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context.support;

import com.baidu.cloud.thirdparty.servlet.ServletConfig;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.springframework.beans.BeansException;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanPostProcessor;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletConfigAware;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletContextAware;

public class ServletContextAwareProcessor
implements BeanPostProcessor {
    @Nullable
    private ServletContext servletContext;
    @Nullable
    private ServletConfig servletConfig;

    protected ServletContextAwareProcessor() {
    }

    public ServletContextAwareProcessor(ServletContext servletContext) {
        this(servletContext, null);
    }

    public ServletContextAwareProcessor(ServletConfig servletConfig) {
        this(null, servletConfig);
    }

    public ServletContextAwareProcessor(@Nullable ServletContext servletContext, @Nullable ServletConfig servletConfig) {
        this.servletContext = servletContext;
        this.servletConfig = servletConfig;
    }

    @Nullable
    protected ServletContext getServletContext() {
        if (this.servletContext == null && this.getServletConfig() != null) {
            return this.getServletConfig().getServletContext();
        }
        return this.servletContext;
    }

    @Nullable
    protected ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (this.getServletContext() != null && bean2 instanceof ServletContextAware) {
            ((ServletContextAware)bean2).setServletContext(this.getServletContext());
        }
        if (this.getServletConfig() != null && bean2 instanceof ServletConfigAware) {
            ((ServletConfigAware)bean2).setServletConfig(this.getServletConfig());
        }
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) {
        return bean2;
    }
}

