/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.filter;

import com.baidu.cloud.thirdparty.servlet.FilterChain;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsConfiguration;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsConfigurationSource;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsProcessor;
import com.baidu.cloud.thirdparty.springframework.web.cors.CorsUtils;
import com.baidu.cloud.thirdparty.springframework.web.cors.DefaultCorsProcessor;
import com.baidu.cloud.thirdparty.springframework.web.filter.OncePerRequestFilter;
import java.io.IOException;

public class CorsFilter
extends OncePerRequestFilter {
    private final CorsConfigurationSource configSource;
    private CorsProcessor processor = new DefaultCorsProcessor();

    public CorsFilter(CorsConfigurationSource configSource) {
        Assert.notNull((Object)configSource, "CorsConfigurationSource must not be null");
        this.configSource = configSource;
    }

    public void setCorsProcessor(CorsProcessor processor) {
        Assert.notNull((Object)processor, "CorsProcessor must not be null");
        this.processor = processor;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean isValid;
        CorsConfiguration corsConfiguration;
        if (CorsUtils.isCorsRequest(request) && (corsConfiguration = this.configSource.getCorsConfiguration(request)) != null && (!(isValid = this.processor.processRequest(corsConfiguration, request, response)) || CorsUtils.isPreFlightRequest(request))) {
            return;
        }
        filterChain.doFilter(request, response);
    }
}

