/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.multipart.commons;

import com.baidu.cloud.thirdparty.apache.commons.fileupload.FileItem;
import com.baidu.cloud.thirdparty.apache.commons.fileupload.FileItemFactory;
import com.baidu.cloud.thirdparty.apache.commons.fileupload.FileUpload;
import com.baidu.cloud.thirdparty.apache.commons.fileupload.disk.DiskFileItemFactory;
import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.LinkedMultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.MultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartFile;
import com.baidu.cloud.thirdparty.springframework.web.multipart.commons.CommonsMultipartFile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CommonsFileUploadSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final DiskFileItemFactory fileItemFactory = this.newFileItemFactory();
    private final FileUpload fileUpload = this.newFileUpload((FileItemFactory)this.getFileItemFactory());
    private boolean uploadTempDirSpecified = false;
    private boolean preserveFilename = false;

    public DiskFileItemFactory getFileItemFactory() {
        return this.fileItemFactory;
    }

    public FileUpload getFileUpload() {
        return this.fileUpload;
    }

    public void setMaxUploadSize(long maxUploadSize) {
        this.fileUpload.setSizeMax(maxUploadSize);
    }

    public void setMaxUploadSizePerFile(long maxUploadSizePerFile) {
        this.fileUpload.setFileSizeMax(maxUploadSizePerFile);
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.fileItemFactory.setSizeThreshold(maxInMemorySize);
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.fileUpload.setHeaderEncoding(defaultEncoding);
    }

    protected String getDefaultEncoding() {
        String encoding = this.getFileUpload().getHeaderEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        return encoding;
    }

    public void setUploadTempDir(Resource uploadTempDir) throws IOException {
        if (!uploadTempDir.exists() && !uploadTempDir.getFile().mkdirs()) {
            throw new IllegalArgumentException("Given uploadTempDir [" + uploadTempDir + "] could not be created");
        }
        this.fileItemFactory.setRepository(uploadTempDir.getFile());
        this.uploadTempDirSpecified = true;
    }

    protected boolean isUploadTempDirSpecified() {
        return this.uploadTempDirSpecified;
    }

    public void setPreserveFilename(boolean preserveFilename) {
        this.preserveFilename = preserveFilename;
    }

    protected DiskFileItemFactory newFileItemFactory() {
        return new DiskFileItemFactory();
    }

    protected abstract FileUpload newFileUpload(FileItemFactory var1);

    protected FileUpload prepareFileUpload(@Nullable String encoding) {
        FileUpload fileUpload;
        FileUpload actualFileUpload = fileUpload = this.getFileUpload();
        if (encoding != null && !encoding.equals(fileUpload.getHeaderEncoding())) {
            actualFileUpload = this.newFileUpload((FileItemFactory)this.getFileItemFactory());
            actualFileUpload.setSizeMax(fileUpload.getSizeMax());
            actualFileUpload.setFileSizeMax(fileUpload.getFileSizeMax());
            actualFileUpload.setHeaderEncoding(encoding);
        }
        return actualFileUpload;
    }

    protected MultipartParsingResult parseFileItems(List<FileItem> fileItems, String encoding) {
        LinkedMultiValueMap<String, MultipartFile> multipartFiles = new LinkedMultiValueMap<String, MultipartFile>();
        HashMap<String, String[]> multipartParameters = new HashMap<String, String[]>();
        HashMap<String, String> multipartParameterContentTypes = new HashMap<String, String>();
        for (FileItem fileItem : fileItems) {
            if (fileItem.isFormField()) {
                String value;
                String partEncoding = this.determineEncoding(fileItem.getContentType(), encoding);
                try {
                    value = fileItem.getString(partEncoding);
                }
                catch (UnsupportedEncodingException ex) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Could not decode multipart item '" + fileItem.getFieldName() + "' with encoding '" + partEncoding + "': using platform default");
                    }
                    value = fileItem.getString();
                }
                String[] curParam = (String[])multipartParameters.get(fileItem.getFieldName());
                if (curParam == null) {
                    multipartParameters.put(fileItem.getFieldName(), new String[]{value});
                } else {
                    String[] newParam = StringUtils.addStringToArray(curParam, value);
                    multipartParameters.put(fileItem.getFieldName(), newParam);
                }
                multipartParameterContentTypes.put(fileItem.getFieldName(), fileItem.getContentType());
                continue;
            }
            CommonsMultipartFile file = this.createMultipartFile(fileItem);
            multipartFiles.add(file.getName(), file);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Found multipart file [" + file.getName() + "] of size " + file.getSize() + " bytes with original filename [" + file.getOriginalFilename() + "], stored " + file.getStorageDescription());
        }
        return new MultipartParsingResult(multipartFiles, multipartParameters, multipartParameterContentTypes);
    }

    protected CommonsMultipartFile createMultipartFile(FileItem fileItem) {
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(fileItem);
        multipartFile.setPreserveFilename(this.preserveFilename);
        return multipartFile;
    }

    protected void cleanupFileItems(MultiValueMap<String, MultipartFile> multipartFiles) {
        for (List files : multipartFiles.values()) {
            for (MultipartFile file : files) {
                if (!(file instanceof CommonsMultipartFile)) continue;
                CommonsMultipartFile cmf = (CommonsMultipartFile)file;
                cmf.getFileItem().delete();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Cleaning up multipart file [" + cmf.getName() + "] with original filename [" + cmf.getOriginalFilename() + "], stored " + cmf.getStorageDescription());
            }
        }
    }

    private String determineEncoding(String contentTypeHeader, String defaultEncoding) {
        if (!StringUtils.hasText(contentTypeHeader)) {
            return defaultEncoding;
        }
        MediaType contentType = MediaType.parseMediaType(contentTypeHeader);
        Charset charset = contentType.getCharset();
        return charset != null ? charset.name() : defaultEncoding;
    }

    protected static class MultipartParsingResult {
        private final MultiValueMap<String, MultipartFile> multipartFiles;
        private final Map<String, String[]> multipartParameters;
        private final Map<String, String> multipartParameterContentTypes;

        public MultipartParsingResult(MultiValueMap<String, MultipartFile> mpFiles, Map<String, String[]> mpParams, Map<String, String> mpParamContentTypes) {
            this.multipartFiles = mpFiles;
            this.multipartParameters = mpParams;
            this.multipartParameterContentTypes = mpParamContentTypes;
        }

        public MultiValueMap<String, MultipartFile> getMultipartFiles() {
            return this.multipartFiles;
        }

        public Map<String, String[]> getMultipartParameters() {
            return this.multipartParameters;
        }

        public Map<String, String> getMultipartParameterContentTypes() {
            return this.multipartParameterContentTypes;
        }
    }
}

