/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.server;

import com.baidu.cloud.thirdparty.springframework.http.HttpStatus;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.web.server.ResponseStatusException;
import java.util.Collections;
import java.util.List;

public class MediaTypeNotSupportedStatusException
extends ResponseStatusException {
    private final List<MediaType> supportedMediaTypes;

    public MediaTypeNotSupportedStatusException(String reason) {
        super(HttpStatus.UNSUPPORTED_MEDIA_TYPE, reason);
        this.supportedMediaTypes = Collections.emptyList();
    }

    public MediaTypeNotSupportedStatusException(List<MediaType> supportedMediaTypes) {
        super(HttpStatus.UNSUPPORTED_MEDIA_TYPE, "Unsupported media type", null);
        this.supportedMediaTypes = Collections.unmodifiableList(supportedMediaTypes);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }
}

