/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.server.adapter;

import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.ServletContextEvent;
import com.baidu.cloud.thirdparty.servlet.ServletContextListener;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.ServletRegistration;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.ConfigurableApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AnnotationConfigApplicationContext;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.HttpHandler;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.WebApplicationInitializer;
import com.baidu.cloud.thirdparty.springframework.web.server.adapter.WebHttpHandlerBuilder;

public abstract class AbstractReactiveWebInitializer
implements WebApplicationInitializer {
    public static final String DEFAULT_SERVLET_NAME = "http-handler-adapter";

    @Override
    public void onStartup(ServletContext servletContext) throws ServletException {
        String servletName = this.getServletName();
        Assert.hasLength(servletName, "getServletName() must not return null or empty");
        ApplicationContext applicationContext = this.createApplicationContext();
        Assert.notNull((Object)applicationContext, "createApplicationContext() must not return null");
        this.refreshApplicationContext(applicationContext);
        this.registerCloseListener(servletContext, applicationContext);
        HttpHandler httpHandler = WebHttpHandlerBuilder.applicationContext(applicationContext).build();
        ServletHttpHandlerAdapter servlet = new ServletHttpHandlerAdapter(httpHandler);
        ServletRegistration.Dynamic registration = servletContext.addServlet(servletName, servlet);
        if (registration == null) {
            throw new IllegalStateException("Failed to register servlet with name '" + servletName + "'. Check if there is another servlet registered under the same name.");
        }
        registration.setLoadOnStartup(1);
        registration.addMapping(this.getServletMapping());
        registration.setAsyncSupported(true);
    }

    protected String getServletName() {
        return DEFAULT_SERVLET_NAME;
    }

    protected ApplicationContext createApplicationContext() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        Object[] configClasses = this.getConfigClasses();
        Assert.notEmpty(configClasses, "No Spring configuration provided through getConfigClasses()");
        context.register((Class<?>[])configClasses);
        return context;
    }

    protected abstract Class<?>[] getConfigClasses();

    protected void refreshApplicationContext(ApplicationContext context) {
        ConfigurableApplicationContext cac;
        if (context instanceof ConfigurableApplicationContext && !(cac = (ConfigurableApplicationContext)context).isActive()) {
            cac.refresh();
        }
    }

    protected void registerCloseListener(ServletContext servletContext, ApplicationContext applicationContext) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac = (ConfigurableApplicationContext)applicationContext;
            ServletContextDestroyedListener listener = new ServletContextDestroyedListener(cac);
            servletContext.addListener(listener);
        }
    }

    protected String getServletMapping() {
        return "/";
    }

    private static class ServletContextDestroyedListener
    implements ServletContextListener {
        private final ConfigurableApplicationContext applicationContext;

        public ServletContextDestroyedListener(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Override
        public void contextInitialized(ServletContextEvent sce) {
        }

        @Override
        public void contextDestroyed(ServletContextEvent sce) {
            this.applicationContext.close();
        }
    }
}

