/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.server.session;

import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.server.ServerWebExchange;
import com.baidu.cloud.thirdparty.springframework.web.server.WebSession;
import com.baidu.cloud.thirdparty.springframework.web.server.session.CookieWebSessionIdResolver;
import com.baidu.cloud.thirdparty.springframework.web.server.session.InMemoryWebSessionStore;
import com.baidu.cloud.thirdparty.springframework.web.server.session.WebSessionIdResolver;
import com.baidu.cloud.thirdparty.springframework.web.server.session.WebSessionManager;
import com.baidu.cloud.thirdparty.springframework.web.server.session.WebSessionStore;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultWebSessionManager
implements WebSessionManager {
    private WebSessionIdResolver sessionIdResolver = new CookieWebSessionIdResolver();
    private WebSessionStore sessionStore = new InMemoryWebSessionStore();

    public void setSessionIdResolver(WebSessionIdResolver sessionIdResolver) {
        Assert.notNull((Object)sessionIdResolver, "WebSessionIdResolver is required");
        this.sessionIdResolver = sessionIdResolver;
    }

    public WebSessionIdResolver getSessionIdResolver() {
        return this.sessionIdResolver;
    }

    public void setSessionStore(WebSessionStore sessionStore) {
        Assert.notNull((Object)sessionStore, "WebSessionStore is required");
        this.sessionStore = sessionStore;
    }

    public WebSessionStore getSessionStore() {
        return this.sessionStore;
    }

    @Override
    public Mono<WebSession> getSession(ServerWebExchange exchange2) {
        return Mono.defer(() -> this.retrieveSession(exchange2).switchIfEmpty(this.sessionStore.createWebSession()).doOnNext(session -> exchange2.getResponse().beforeCommit(() -> this.save(exchange2, (WebSession)session))));
    }

    private Mono<WebSession> retrieveSession(ServerWebExchange exchange2) {
        return Flux.fromIterable(this.getSessionIdResolver().resolveSessionIds(exchange2)).concatMap(this.sessionStore::retrieveSession).next();
    }

    private Mono<Void> save(ServerWebExchange exchange2, WebSession session) {
        List<String> ids = this.getSessionIdResolver().resolveSessionIds(exchange2);
        if (!session.isStarted() || session.isExpired()) {
            if (!ids.isEmpty()) {
                this.sessionIdResolver.expireSession(exchange2);
            }
            return Mono.empty();
        }
        if (ids.isEmpty() || !session.getId().equals(ids.get(0))) {
            this.sessionIdResolver.setSessionId(exchange2, session.getId());
        }
        return session.save();
    }
}

