/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation;

import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactoryUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanInitializationException;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContext;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import com.baidu.cloud.thirdparty.springframework.web.accept.ContentNegotiationManager;
import com.baidu.cloud.thirdparty.springframework.web.servlet.View;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ViewResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.config.annotation.UrlBasedViewResolverRegistration;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.BeanNameViewResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.InternalResourceViewResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.groovy.GroovyMarkupConfigurer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.script.ScriptTemplateConfigurer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.script.ScriptTemplateViewResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.tiles3.TilesConfigurer;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.tiles3.TilesViewResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ViewResolverRegistry {
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private ContentNegotiatingViewResolver contentNegotiatingResolver;
    private final List<ViewResolver> viewResolvers = new ArrayList<ViewResolver>(4);
    @Nullable
    private Integer order;

    public ViewResolverRegistry(ContentNegotiationManager contentNegotiationManager, @Nullable ApplicationContext context) {
        this.contentNegotiationManager = contentNegotiationManager;
        this.applicationContext = context;
    }

    public boolean hasRegistrations() {
        return this.contentNegotiatingResolver != null || !this.viewResolvers.isEmpty();
    }

    public void enableContentNegotiation(View ... defaultViews) {
        this.initContentNegotiatingViewResolver(defaultViews);
    }

    public void enableContentNegotiation(boolean useNotAcceptableStatus, View ... defaultViews) {
        ContentNegotiatingViewResolver vr = this.initContentNegotiatingViewResolver(defaultViews);
        vr.setUseNotAcceptableStatusCode(useNotAcceptableStatus);
    }

    private ContentNegotiatingViewResolver initContentNegotiatingViewResolver(View[] defaultViews) {
        this.order = this.order != null ? this.order : Integer.MIN_VALUE;
        if (this.contentNegotiatingResolver != null) {
            if (!ObjectUtils.isEmpty(defaultViews) && !CollectionUtils.isEmpty(this.contentNegotiatingResolver.getDefaultViews())) {
                ArrayList<View> views = new ArrayList<View>(this.contentNegotiatingResolver.getDefaultViews());
                views.addAll(Arrays.asList(defaultViews));
                this.contentNegotiatingResolver.setDefaultViews(views);
            }
        } else {
            this.contentNegotiatingResolver = new ContentNegotiatingViewResolver();
            this.contentNegotiatingResolver.setDefaultViews(Arrays.asList(defaultViews));
            this.contentNegotiatingResolver.setViewResolvers(this.viewResolvers);
            if (this.contentNegotiationManager != null) {
                this.contentNegotiatingResolver.setContentNegotiationManager(this.contentNegotiationManager);
            }
        }
        return this.contentNegotiatingResolver;
    }

    public UrlBasedViewResolverRegistration jsp() {
        return this.jsp("/WEB-INF/", ".jsp");
    }

    public UrlBasedViewResolverRegistration jsp(String prefix, String suffix) {
        InternalResourceViewResolver resolver = new InternalResourceViewResolver();
        resolver.setPrefix(prefix);
        resolver.setSuffix(suffix);
        this.viewResolvers.add(resolver);
        return new UrlBasedViewResolverRegistration(resolver);
    }

    public UrlBasedViewResolverRegistration tiles() {
        if (!this.checkBeanOfType(TilesConfigurer.class)) {
            throw new BeanInitializationException("In addition to a Tiles view resolver there must also be a single TilesConfigurer bean in this web application context (or its parent).");
        }
        TilesRegistration registration = new TilesRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public UrlBasedViewResolverRegistration freeMarker() {
        if (!this.checkBeanOfType(FreeMarkerConfigurer.class)) {
            throw new BeanInitializationException("In addition to a FreeMarker view resolver there must also be a single FreeMarkerConfig bean in this web application context (or its parent): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.");
        }
        FreeMarkerRegistration registration = new FreeMarkerRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public UrlBasedViewResolverRegistration groovy() {
        if (!this.checkBeanOfType(GroovyMarkupConfigurer.class)) {
            throw new BeanInitializationException("In addition to a Groovy markup view resolver there must also be a single GroovyMarkupConfig bean in this web application context (or its parent): GroovyMarkupConfigurer is the usual implementation. This bean may be given any name.");
        }
        GroovyMarkupRegistration registration = new GroovyMarkupRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public UrlBasedViewResolverRegistration scriptTemplate() {
        if (!this.checkBeanOfType(ScriptTemplateConfigurer.class)) {
            throw new BeanInitializationException("In addition to a script template view resolver there must also be a single ScriptTemplateConfig bean in this web application context (or its parent): ScriptTemplateConfigurer is the usual implementation. This bean may be given any name.");
        }
        ScriptRegistration registration = new ScriptRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public void beanName() {
        BeanNameViewResolver resolver = new BeanNameViewResolver();
        this.viewResolvers.add(resolver);
    }

    public void viewResolver(ViewResolver viewResolver) {
        if (viewResolver instanceof ContentNegotiatingViewResolver) {
            throw new BeanInitializationException("addViewResolver cannot be used to configure a ContentNegotiatingViewResolver. Please use the method enableContentNegotiation instead.");
        }
        this.viewResolvers.add(viewResolver);
    }

    public void order(int order) {
        this.order = order;
    }

    private boolean checkBeanOfType(Class<?> beanType) {
        return this.applicationContext == null || !ObjectUtils.isEmpty(BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.applicationContext, beanType, false, false));
    }

    protected int getOrder() {
        return this.order != null ? this.order : Integer.MAX_VALUE;
    }

    protected List<ViewResolver> getViewResolvers() {
        if (this.contentNegotiatingResolver != null) {
            return Collections.singletonList(this.contentNegotiatingResolver);
        }
        return this.viewResolvers;
    }

    private static class ScriptRegistration
    extends UrlBasedViewResolverRegistration {
        public ScriptRegistration() {
            super(new ScriptTemplateViewResolver());
            this.getViewResolver();
        }
    }

    private static class GroovyMarkupRegistration
    extends UrlBasedViewResolverRegistration {
        public GroovyMarkupRegistration() {
            super(new GroovyMarkupViewResolver());
            this.getViewResolver().setSuffix(".tpl");
        }
    }

    private static class FreeMarkerRegistration
    extends UrlBasedViewResolverRegistration {
        public FreeMarkerRegistration() {
            super(new FreeMarkerViewResolver());
            this.getViewResolver().setSuffix(".ftl");
        }
    }

    private static class TilesRegistration
    extends UrlBasedViewResolverRegistration {
        public TilesRegistration() {
            super(new TilesViewResolver());
        }
    }
}

