/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.i18n;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.context.i18n.LocaleContext;
import com.baidu.cloud.thirdparty.springframework.context.i18n.TimeZoneAwareLocaleContext;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.servlet.i18n.AbstractLocaleContextResolver;
import java.util.Locale;
import java.util.TimeZone;

public class FixedLocaleResolver
extends AbstractLocaleContextResolver {
    public FixedLocaleResolver() {
        this.setDefaultLocale(Locale.getDefault());
    }

    public FixedLocaleResolver(Locale locale) {
        this.setDefaultLocale(locale);
    }

    public FixedLocaleResolver(Locale locale, TimeZone timeZone) {
        this.setDefaultLocale(locale);
        this.setDefaultTimeZone(timeZone);
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = this.getDefaultLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    @Override
    public LocaleContext resolveLocaleContext(HttpServletRequest request) {
        return new TimeZoneAwareLocaleContext(){

            @Override
            @Nullable
            public Locale getLocale() {
                return FixedLocaleResolver.this.getDefaultLocale();
            }

            @Override
            public TimeZone getTimeZone() {
                return FixedLocaleResolver.this.getDefaultTimeZone();
            }
        };
    }

    @Override
    public void setLocaleContext(HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable LocaleContext localeContext) {
        throw new UnsupportedOperationException("Cannot change fixed locale - use a different locale resolution strategy");
    }
}

