/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ModelAndView;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.AbstractController;
import com.baidu.cloud.thirdparty.springframework.web.servlet.support.RequestContextUtils;
import com.baidu.cloud.thirdparty.springframework.web.util.UrlPathHelper;

public abstract class AbstractUrlViewController
extends AbstractController {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setRemoveSemicolonContent(boolean removeSemicolonContent) {
        this.urlPathHelper.setRemoveSemicolonContent(removeSemicolonContent);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, "UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    protected UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(request);
        String viewName = this.getViewNameForRequest(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Returning view name '" + viewName + "' for lookup path [" + lookupPath + "]");
        }
        return new ModelAndView(viewName, RequestContextUtils.getInputFlashMap(request));
    }

    protected abstract String getViewNameForRequest(HttpServletRequest var1);
}

