/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc;

import com.baidu.cloud.thirdparty.servlet.Servlet;
import com.baidu.cloud.thirdparty.servlet.ServletConfig;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanNameAware;
import com.baidu.cloud.thirdparty.springframework.beans.factory.DisposableBean;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ReflectionUtils;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ModelAndView;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.AbstractController;
import java.util.Enumeration;
import java.util.Properties;

public class ServletWrappingController
extends AbstractController
implements BeanNameAware,
InitializingBean,
DisposableBean {
    @Nullable
    private Class<? extends Servlet> servletClass;
    @Nullable
    private String servletName;
    private Properties initParameters = new Properties();
    @Nullable
    private String beanName;
    @Nullable
    private Servlet servletInstance;

    public ServletWrappingController() {
        super(false);
    }

    public void setServletClass(Class<? extends Servlet> servletClass) {
        this.servletClass = servletClass;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void setInitParameters(Properties initParameters) {
        this.initParameters = initParameters;
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.servletClass == null) {
            throw new IllegalArgumentException("'servletClass' is required");
        }
        if (this.servletName == null) {
            this.servletName = this.beanName;
        }
        this.servletInstance = ReflectionUtils.accessibleConstructor(this.servletClass, new Class[0]).newInstance(new Object[0]);
        this.servletInstance.init(new DelegatingServletConfig());
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Assert.state(this.servletInstance != null, "No Servlet instance");
        this.servletInstance.service(request, response);
        return null;
    }

    @Override
    public void destroy() {
        if (this.servletInstance != null) {
            this.servletInstance.destroy();
        }
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        @Override
        @Nullable
        public String getServletName() {
            return ServletWrappingController.this.servletName;
        }

        @Override
        @Nullable
        public ServletContext getServletContext() {
            return ServletWrappingController.this.getServletContext();
        }

        @Override
        public String getInitParameter(String paramName) {
            return ServletWrappingController.this.initParameters.getProperty(paramName);
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return ServletWrappingController.this.initParameters.keys();
        }
    }
}

