/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.core.MethodParameter;
import com.baidu.cloud.thirdparty.springframework.http.HttpHeaders;
import com.baidu.cloud.thirdparty.springframework.http.server.ServletServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodReturnValueHandler;
import com.baidu.cloud.thirdparty.springframework.web.method.support.ModelAndViewContainer;

public class HttpHeadersReturnValueHandler
implements HandlerMethodReturnValueHandler {
    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return HttpHeaders.class.isAssignableFrom(returnType.getParameterType());
    }

    @Override
    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        mavContainer.setRequestHandled(true);
        Assert.state(returnValue instanceof HttpHeaders, "HttpHeaders expected");
        HttpHeaders headers = (HttpHeaders)returnValue;
        if (!headers.isEmpty()) {
            HttpServletResponse servletResponse = webRequest.getNativeResponse(HttpServletResponse.class);
            Assert.state(servletResponse != null, "No HttpServletResponse");
            ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(servletResponse);
            outputMessage.getHeaders().putAll(headers);
            outputMessage.getBody();
        }
    }
}

