/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.aop.framework.ProxyFactory;
import com.baidu.cloud.thirdparty.springframework.aop.target.EmptyTargetSource;
import com.baidu.cloud.thirdparty.springframework.beans.factory.NoSuchBeanDefinitionException;
import com.baidu.cloud.thirdparty.springframework.beans.factory.NoUniqueBeanDefinitionException;
import com.baidu.cloud.thirdparty.springframework.cglib.core.SpringNamingPolicy;
import com.baidu.cloud.thirdparty.springframework.cglib.proxy.Callback;
import com.baidu.cloud.thirdparty.springframework.cglib.proxy.Enhancer;
import com.baidu.cloud.thirdparty.springframework.cglib.proxy.Factory;
import com.baidu.cloud.thirdparty.springframework.cglib.proxy.MethodInterceptor;
import com.baidu.cloud.thirdparty.springframework.cglib.proxy.MethodProxy;
import com.baidu.cloud.thirdparty.springframework.core.DefaultParameterNameDiscoverer;
import com.baidu.cloud.thirdparty.springframework.core.MethodIntrospector;
import com.baidu.cloud.thirdparty.springframework.core.ParameterNameDiscoverer;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotatedElementUtils;
import com.baidu.cloud.thirdparty.springframework.core.annotation.SynthesizingMethodParameter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.objenesis.ObjenesisException;
import com.baidu.cloud.thirdparty.springframework.objenesis.SpringObjenesis;
import com.baidu.cloud.thirdparty.springframework.util.AntPathMatcher;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import com.baidu.cloud.thirdparty.springframework.util.PathMatcher;
import com.baidu.cloud.thirdparty.springframework.util.ReflectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.bind.annotation.RequestMapping;
import com.baidu.cloud.thirdparty.springframework.web.context.WebApplicationContext;
import com.baidu.cloud.thirdparty.springframework.web.context.request.RequestAttributes;
import com.baidu.cloud.thirdparty.springframework.web.context.request.RequestContextHolder;
import com.baidu.cloud.thirdparty.springframework.web.context.request.ServletRequestAttributes;
import com.baidu.cloud.thirdparty.springframework.web.method.HandlerMethod;
import com.baidu.cloud.thirdparty.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.support.CompositeUriComponentsContributor;
import com.baidu.cloud.thirdparty.springframework.web.servlet.DispatcherServlet;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.mvc.method.annotation.PathVariableMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.support.ServletUriComponentsBuilder;
import com.baidu.cloud.thirdparty.springframework.web.util.UriComponentsBuilder;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;

public class MvcUriComponentsBuilder {
    public static final String MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME = "mvcUriComponentsContributor";
    private static final Log logger = LogFactory.getLog(MvcUriComponentsBuilder.class);
    private static final SpringObjenesis objenesis = new SpringObjenesis();
    private static final PathMatcher pathMatcher = new AntPathMatcher();
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private static final CompositeUriComponentsContributor defaultUriComponentsContributor = new CompositeUriComponentsContributor(new PathVariableMethodArgumentResolver(), new RequestParamMethodArgumentResolver(false));
    private final UriComponentsBuilder baseUrl;

    protected MvcUriComponentsBuilder(UriComponentsBuilder baseUrl) {
        Assert.notNull((Object)baseUrl, "'baseUrl' is required");
        this.baseUrl = baseUrl;
    }

    public static MvcUriComponentsBuilder relativeTo(UriComponentsBuilder baseUrl) {
        return new MvcUriComponentsBuilder(baseUrl);
    }

    public static UriComponentsBuilder fromController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(null, controllerType);
    }

    public static UriComponentsBuilder fromController(@Nullable UriComponentsBuilder builder, Class<?> controllerType) {
        builder = MvcUriComponentsBuilder.getBaseUrlToUse(builder);
        String mapping = MvcUriComponentsBuilder.getTypeRequestMapping(controllerType);
        return builder.path(mapping);
    }

    public static UriComponentsBuilder fromMethodName(Class<?> controllerType, String methodName, Object ... args) {
        Method method = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args);
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method, args);
    }

    public static UriComponentsBuilder fromMethodName(UriComponentsBuilder builder, Class<?> controllerType, String methodName, Object ... args) {
        Method method = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args);
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method, args);
    }

    public static UriComponentsBuilder fromMethodCall(Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, info, "MethodInvocationInfo required");
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method, arguments);
    }

    public static UriComponentsBuilder fromMethodCall(UriComponentsBuilder builder, Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, info, "MethodInvocationInfo required");
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method, arguments);
    }

    public static MethodArgumentBuilder fromMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(null, mappingName);
    }

    public static MethodArgumentBuilder fromMappingName(@Nullable UriComponentsBuilder builder, String name) {
        RequestMappingInfoHandlerMapping handlerMapping = MvcUriComponentsBuilder.getRequestMappingInfoHandlerMapping();
        List<HandlerMethod> handlerMethods = handlerMapping.getHandlerMethodsForMappingName(name);
        if (handlerMethods == null) {
            throw new IllegalArgumentException("Mapping mappingName not found: " + name);
        }
        if (handlerMethods.size() != 1) {
            throw new IllegalArgumentException("No unique match for mapping mappingName " + name + ": " + handlerMethods);
        }
        HandlerMethod handlerMethod = handlerMethods.get(0);
        Class<?> controllerType = handlerMethod.getBeanType();
        Method method = handlerMethod.getMethod();
        return new MethodArgumentBuilder(builder, controllerType, method);
    }

    public static UriComponentsBuilder fromMethod(Class<?> controllerType, Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method, args);
    }

    public static UriComponentsBuilder fromMethod(UriComponentsBuilder baseUrl, @Nullable Class<?> controllerType, Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodInternal(baseUrl, controllerType != null ? controllerType : method.getDeclaringClass(), method, args);
    }

    private static UriComponentsBuilder fromMethodInternal(@Nullable UriComponentsBuilder baseUrl, Class<?> controllerType, Method method, Object ... args) {
        baseUrl = MvcUriComponentsBuilder.getBaseUrlToUse(baseUrl);
        String typePath = MvcUriComponentsBuilder.getTypeRequestMapping(controllerType);
        String methodPath = MvcUriComponentsBuilder.getMethodRequestMapping(method);
        String path = pathMatcher.combine(typePath, methodPath);
        baseUrl.path(path);
        return MvcUriComponentsBuilder.applyContributors(baseUrl, method, args);
    }

    private static UriComponentsBuilder getBaseUrlToUse(@Nullable UriComponentsBuilder baseUrl) {
        if (baseUrl != null) {
            return baseUrl.cloneBuilder();
        }
        return ServletUriComponentsBuilder.fromCurrentServletMapping();
    }

    private static String getTypeRequestMapping(Class<?> controllerType) {
        Assert.notNull(controllerType, "'controllerType' must not be null");
        RequestMapping requestMapping = AnnotatedElementUtils.findMergedAnnotation(controllerType, RequestMapping.class);
        if (requestMapping == null) {
            return "/";
        }
        Object[] paths = requestMapping.path();
        if (ObjectUtils.isEmpty(paths) || StringUtils.isEmpty(paths[0])) {
            return "/";
        }
        if (paths.length > 1 && logger.isWarnEnabled()) {
            logger.warn("Multiple paths on controller " + controllerType.getName() + ", using first one");
        }
        return paths[0];
    }

    private static String getMethodRequestMapping(Method method) {
        Assert.notNull((Object)method, "'method' must not be null");
        RequestMapping requestMapping = AnnotatedElementUtils.findMergedAnnotation(method, RequestMapping.class);
        if (requestMapping == null) {
            throw new IllegalArgumentException("No @RequestMapping on: " + method.toGenericString());
        }
        Object[] paths = requestMapping.path();
        if (ObjectUtils.isEmpty(paths) || StringUtils.isEmpty(paths[0])) {
            return "/";
        }
        if (paths.length > 1 && logger.isWarnEnabled()) {
            logger.warn("Multiple paths on method " + method.toGenericString() + ", using first one");
        }
        return paths[0];
    }

    private static Method getMethod(Class<?> controllerType, String methodName, Object ... args) {
        ReflectionUtils.MethodFilter selector = method -> {
            String name = method.getName();
            int argLength = method.getParameterCount();
            return name.equals(methodName) && argLength == args.length;
        };
        Set<Method> methods = MethodIntrospector.selectMethods(controllerType, selector);
        if (methods.size() == 1) {
            return methods.iterator().next();
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException(String.format("Found two methods named '%s' accepting arguments %s in controller %s: [%s]", methodName, Arrays.asList(args), controllerType.getName(), methods));
        }
        throw new IllegalArgumentException("No method named '" + methodName + "' with " + args.length + " arguments found in controller " + controllerType.getName());
    }

    private static UriComponentsBuilder applyContributors(UriComponentsBuilder builder, Method method, Object ... args) {
        int argCount;
        int paramCount;
        CompositeUriComponentsContributor contributor = MvcUriComponentsBuilder.getConfiguredUriComponentsContributor();
        if (contributor == null) {
            logger.debug("Using default CompositeUriComponentsContributor");
            contributor = defaultUriComponentsContributor;
        }
        if ((paramCount = method.getParameterCount()) != (argCount = args.length)) {
            throw new IllegalArgumentException("Number of method parameters " + paramCount + " does not match number of argument values " + argCount);
        }
        HashMap<String, Object> uriVars = new HashMap<String, Object>();
        for (int i = 0; i < paramCount; ++i) {
            SynthesizingMethodParameter param = new SynthesizingMethodParameter(method, i);
            param.initParameterNameDiscovery(parameterNameDiscoverer);
            contributor.contributeMethodArgument(param, args[i], builder, uriVars);
        }
        return builder.uriVariables(uriVars);
    }

    @Nullable
    private static CompositeUriComponentsContributor getConfiguredUriComponentsContributor() {
        WebApplicationContext wac = MvcUriComponentsBuilder.getWebApplicationContext();
        if (wac == null) {
            return null;
        }
        try {
            return wac.getBean(MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME, CompositeUriComponentsContributor.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("No CompositeUriComponentsContributor bean with name 'mvcUriComponentsContributor'");
            }
            return null;
        }
    }

    private static RequestMappingInfoHandlerMapping getRequestMappingInfoHandlerMapping() {
        WebApplicationContext wac = MvcUriComponentsBuilder.getWebApplicationContext();
        Assert.notNull((Object)wac, "Cannot lookup handler method mappings without WebApplicationContext");
        try {
            return wac.getBean(RequestMappingInfoHandlerMapping.class);
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw new IllegalStateException("More than one RequestMappingInfoHandlerMapping beans found", ex);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new IllegalStateException("No RequestMappingInfoHandlerMapping bean", ex);
        }
    }

    @Nullable
    private static WebApplicationContext getWebApplicationContext() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            logger.debug("No request bound to the current thread: not in a DispatcherServlet request?");
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        WebApplicationContext wac = (WebApplicationContext)request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (wac == null) {
            logger.debug("No WebApplicationContext found: not in a DispatcherServlet request?");
            return null;
        }
        return wac;
    }

    public static <T> T on(Class<T> controllerType) {
        return MvcUriComponentsBuilder.controller(controllerType);
    }

    public static <T> T controller(Class<T> controllerType) {
        Assert.notNull(controllerType, "'controllerType' must not be null");
        return MvcUriComponentsBuilder.initProxy(controllerType, new ControllerMethodInvocationInterceptor(controllerType));
    }

    private static <T> T initProxy(Class<?> type, ControllerMethodInvocationInterceptor interceptor) {
        if (type == Object.class) {
            return (T)interceptor;
        }
        if (type.isInterface()) {
            ProxyFactory factory = new ProxyFactory(EmptyTargetSource.INSTANCE);
            factory.addInterface(type);
            factory.addInterface(MethodInvocationInfo.class);
            factory.addAdvice(interceptor);
            return (T)factory.getProxy();
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setInterfaces(new Class[]{MethodInvocationInfo.class});
        enhancer.setNamingPolicy(SpringNamingPolicy.INSTANCE);
        enhancer.setCallbackType(MethodInterceptor.class);
        Class proxyClass = enhancer.createClass();
        T proxy = null;
        if (objenesis.isWorthTrying()) {
            try {
                proxy = objenesis.newInstance(proxyClass, enhancer.getUseCache());
            }
            catch (ObjenesisException ex) {
                logger.debug("Unable to instantiate controller proxy using Objenesis, falling back to regular construction", ex);
            }
        }
        if (proxy == null) {
            try {
                proxy = ReflectionUtils.accessibleConstructor(proxyClass, new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to instantiate controller proxy using Objenesis, and regular controller instantiation via default constructor fails as well", ex);
            }
        }
        ((Factory)proxy).setCallbacks(new Callback[]{interceptor});
        return proxy;
    }

    public UriComponentsBuilder withController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(this.baseUrl, controllerType);
    }

    public UriComponentsBuilder withMethodName(Class<?> controllerType, String methodName, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodName(this.baseUrl, controllerType, methodName, args);
    }

    public UriComponentsBuilder withMethodCall(Object invocationInfo) {
        return MvcUriComponentsBuilder.fromMethodCall(this.baseUrl, invocationInfo);
    }

    public MethodArgumentBuilder withMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(this.baseUrl, mappingName);
    }

    public UriComponentsBuilder withMethod(Class<?> controllerType, Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethod(this.baseUrl, controllerType, method, args);
    }

    public static class MethodArgumentBuilder {
        private final Class<?> controllerType;
        private final Method method;
        private final Object[] argumentValues;
        private final UriComponentsBuilder baseUrl;

        public MethodArgumentBuilder(Class<?> controllerType, Method method) {
            this(null, controllerType, method);
        }

        public MethodArgumentBuilder(@Nullable UriComponentsBuilder baseUrl, Class<?> controllerType, Method method) {
            Assert.notNull(controllerType, "'controllerType' is required");
            Assert.notNull((Object)method, "'method' is required");
            this.baseUrl = baseUrl != null ? baseUrl : UriComponentsBuilder.fromPath(MethodArgumentBuilder.getPath());
            this.controllerType = controllerType;
            this.method = method;
            this.argumentValues = new Object[method.getParameterCount()];
            for (int i = 0; i < this.argumentValues.length; ++i) {
                this.argumentValues[i] = null;
            }
        }

        private static String getPath() {
            ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentServletMapping();
            String path = builder.build().getPath();
            return path != null ? path : "";
        }

        public MethodArgumentBuilder arg(int index, Object value) {
            this.argumentValues[index] = value;
            return this;
        }

        public MethodArgumentBuilder encode() {
            this.baseUrl.encode();
            return this;
        }

        public String build() {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).build(false).encode().toUriString();
        }

        public String buildAndExpand(Object ... uriVars) {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).build(false).expand(uriVars).encode().toString();
        }
    }

    private static class ControllerMethodInvocationInterceptor
    implements MethodInterceptor,
    org.aopalliance.intercept.MethodInterceptor,
    MethodInvocationInfo {
        private final Class<?> controllerType;
        @Nullable
        private Method controllerMethod;
        @Nullable
        private Object[] argumentValues;

        ControllerMethodInvocationInterceptor(Class<?> controllerType) {
            this.controllerType = controllerType;
        }

        @Override
        @Nullable
        public Object intercept(Object obj, Method method, Object[] args, @Nullable MethodProxy proxy) {
            if (method.getName().equals("getControllerType")) {
                return this.controllerType;
            }
            if (method.getName().equals("getControllerMethod")) {
                return this.controllerMethod;
            }
            if (method.getName().equals("getArgumentValues")) {
                return this.argumentValues;
            }
            if (ReflectionUtils.isObjectMethod(method)) {
                return ReflectionUtils.invokeMethod(method, obj, args);
            }
            this.controllerMethod = method;
            this.argumentValues = args;
            Class<?> returnType = method.getReturnType();
            try {
                return returnType == Void.TYPE ? null : returnType.cast(MvcUriComponentsBuilder.initProxy(returnType, this));
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to create proxy for controller method return type: " + method, ex);
            }
        }

        @Override
        @Nullable
        public Object invoke(MethodInvocation inv) throws Throwable {
            return this.intercept(inv.getThis(), inv.getMethod(), inv.getArguments(), null);
        }

        @Override
        public Class<?> getControllerType() {
            return this.controllerType;
        }

        @Override
        public Method getControllerMethod() {
            Assert.state(this.controllerMethod != null, "Not initialized yet");
            return this.controllerMethod;
        }

        @Override
        public Object[] getArgumentValues() {
            Assert.state(this.argumentValues != null, "Not initialized yet");
            return this.argumentValues;
        }
    }

    public static interface MethodInvocationInfo {
        public Class<?> getControllerType();

        public Method getControllerMethod();

        public Object[] getArgumentValues();
    }
}

