/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.resource;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.cache.Cache;
import com.baidu.cloud.thirdparty.springframework.cache.CacheManager;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.AbstractResourceResolver;
import com.baidu.cloud.thirdparty.springframework.web.servlet.resource.ResourceResolverChain;
import java.util.List;

public class CachingResourceResolver
extends AbstractResourceResolver {
    public static final String RESOLVED_RESOURCE_CACHE_KEY_PREFIX = "resolvedResource:";
    public static final String RESOLVED_URL_PATH_CACHE_KEY_PREFIX = "resolvedUrlPath:";
    private final Cache cache;

    public CachingResourceResolver(Cache cache) {
        Assert.notNull((Object)cache, "Cache is required");
        this.cache = cache;
    }

    public CachingResourceResolver(CacheManager cacheManager, String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("Cache '" + cacheName + "' not found");
        }
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    protected Resource resolveResourceInternal(@Nullable HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String key = this.computeKey(request, requestPath);
        Resource resource = this.cache.get((Object)key, Resource.class);
        if (resource != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Found match: " + resource);
            }
            return resource;
        }
        resource = chain.resolveResource(request, requestPath, locations);
        if (resource != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Putting resolved resource in cache: " + resource);
            }
            this.cache.put(key, resource);
        }
        return resource;
    }

    protected String computeKey(@Nullable HttpServletRequest request, String requestPath) {
        String encoding;
        StringBuilder key = new StringBuilder(RESOLVED_RESOURCE_CACHE_KEY_PREFIX);
        key.append(requestPath);
        if (request != null && (encoding = request.getHeader("Accept-Encoding")) != null && encoding.contains("gzip")) {
            key.append("+encoding=gzip");
        }
        return key.toString();
    }

    @Override
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String key = RESOLVED_URL_PATH_CACHE_KEY_PREFIX + resourceUrlPath;
        String resolvedUrlPath = this.cache.get((Object)key, String.class);
        if (resolvedUrlPath != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Found match: \"" + resolvedUrlPath + "\"");
            }
            return resolvedUrlPath;
        }
        resolvedUrlPath = chain.resolveUrlPath(resourceUrlPath, locations);
        if (resolvedUrlPath != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Putting resolved resource URL path in cache: \"" + resolvedUrlPath + "\"");
            }
            this.cache.put(key, resolvedUrlPath);
        }
        return resolvedUrlPath;
    }
}

