/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.support;

import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.ServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpSession;
import com.baidu.cloud.thirdparty.servlet.jsp.jstl.core.Config;
import com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.LocalizationContext;
import com.baidu.cloud.thirdparty.springframework.context.MessageSource;
import com.baidu.cloud.thirdparty.springframework.context.support.MessageSourceResourceBundle;
import com.baidu.cloud.thirdparty.springframework.context.support.ResourceBundleMessageSource;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.web.servlet.support.RequestContext;
import com.baidu.cloud.thirdparty.springframework.web.servlet.support.RequestContextUtils;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class JstlUtils {
    public static MessageSource getJstlAwareMessageSource(@Nullable ServletContext servletContext, MessageSource messageSource) {
        String jstlInitParam;
        if (servletContext != null && (jstlInitParam = servletContext.getInitParameter("com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.localizationContext")) != null) {
            ResourceBundleMessageSource jstlBundleWrapper = new ResourceBundleMessageSource();
            jstlBundleWrapper.setBasename(jstlInitParam);
            jstlBundleWrapper.setParentMessageSource(messageSource);
            return jstlBundleWrapper;
        }
        return messageSource;
    }

    public static void exposeLocalizationContext(HttpServletRequest request, @Nullable MessageSource messageSource) {
        Locale jstlLocale = RequestContextUtils.getLocale(request);
        Config.set((ServletRequest)request, (String)"com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.locale", (Object)jstlLocale);
        TimeZone timeZone = RequestContextUtils.getTimeZone(request);
        if (timeZone != null) {
            Config.set((ServletRequest)request, (String)"com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.timeZone", (Object)timeZone);
        }
        if (messageSource != null) {
            SpringLocalizationContext jstlContext = new SpringLocalizationContext(messageSource, request);
            Config.set((ServletRequest)request, (String)"com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.localizationContext", (Object)((Object)jstlContext));
        }
    }

    public static void exposeLocalizationContext(RequestContext requestContext) {
        Config.set((ServletRequest)requestContext.getRequest(), (String)"com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.locale", (Object)requestContext.getLocale());
        TimeZone timeZone = requestContext.getTimeZone();
        if (timeZone != null) {
            Config.set((ServletRequest)requestContext.getRequest(), (String)"com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.timeZone", (Object)timeZone);
        }
        MessageSource messageSource = JstlUtils.getJstlAwareMessageSource(requestContext.getServletContext(), requestContext.getMessageSource());
        SpringLocalizationContext jstlContext = new SpringLocalizationContext(messageSource, requestContext.getRequest());
        Config.set((ServletRequest)requestContext.getRequest(), (String)"com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.localizationContext", (Object)((Object)jstlContext));
    }

    private static class SpringLocalizationContext
    extends LocalizationContext {
        private final MessageSource messageSource;
        private final HttpServletRequest request;

        public SpringLocalizationContext(MessageSource messageSource, HttpServletRequest request) {
            this.messageSource = messageSource;
            this.request = request;
        }

        public ResourceBundle getResourceBundle() {
            Object lcObject;
            HttpSession session = this.request.getSession(false);
            if (session != null && (lcObject = Config.get((HttpSession)session, (String)"com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.localizationContext")) instanceof LocalizationContext) {
                ResourceBundle lcBundle = ((LocalizationContext)lcObject).getResourceBundle();
                return new MessageSourceResourceBundle(this.messageSource, this.getLocale(), lcBundle);
            }
            return new MessageSourceResourceBundle(this.messageSource, this.getLocale());
        }

        public Locale getLocale() {
            Object localeObject;
            HttpSession session = this.request.getSession(false);
            if (session != null && (localeObject = Config.get((HttpSession)session, (String)"com.baidu.cloud.thirdparty.servlet.jsp.jstl.fmt.locale")) instanceof Locale) {
                return (Locale)localeObject;
            }
            return RequestContextUtils.getLocale(this.request);
        }
    }
}

