/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.support;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.http.server.ServletServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.context.request.RequestAttributes;
import com.baidu.cloud.thirdparty.springframework.web.context.request.RequestContextHolder;
import com.baidu.cloud.thirdparty.springframework.web.context.request.ServletRequestAttributes;
import com.baidu.cloud.thirdparty.springframework.web.util.UriComponents;
import com.baidu.cloud.thirdparty.springframework.web.util.UriComponentsBuilder;
import com.baidu.cloud.thirdparty.springframework.web.util.UriUtils;
import com.baidu.cloud.thirdparty.springframework.web.util.UrlPathHelper;
import java.util.Enumeration;

public class ServletUriComponentsBuilder
extends UriComponentsBuilder {
    @Nullable
    private String originalPath;

    protected ServletUriComponentsBuilder() {
    }

    protected ServletUriComponentsBuilder(ServletUriComponentsBuilder other) {
        super(other);
        this.originalPath = other.originalPath;
    }

    public static ServletUriComponentsBuilder fromContextPath(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.initFromRequest(request);
        String forwardedPrefix = ServletUriComponentsBuilder.getForwardedPrefix(request);
        builder.replacePath(forwardedPrefix != null ? forwardedPrefix : request.getContextPath());
        return builder;
    }

    public static ServletUriComponentsBuilder fromServletMapping(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromContextPath(request);
        if (StringUtils.hasText(new UrlPathHelper().getPathWithinServletMapping(request))) {
            builder.path(request.getServletPath());
        }
        return builder;
    }

    public static ServletUriComponentsBuilder fromRequestUri(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.initFromRequest(request);
        builder.initPath(ServletUriComponentsBuilder.getRequestUriWithForwardedPrefix(request));
        return builder;
    }

    public static ServletUriComponentsBuilder fromRequest(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.initFromRequest(request);
        builder.initPath(ServletUriComponentsBuilder.getRequestUriWithForwardedPrefix(request));
        builder.query(request.getQueryString());
        return builder;
    }

    private static ServletUriComponentsBuilder initFromRequest(HttpServletRequest request) {
        ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
        UriComponents uriComponents = UriComponentsBuilder.fromHttpRequest(httpRequest).build();
        String scheme = uriComponents.getScheme();
        String host = uriComponents.getHost();
        int port = uriComponents.getPort();
        ServletUriComponentsBuilder builder = new ServletUriComponentsBuilder();
        builder.scheme(scheme);
        builder.host(host);
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            builder.port(port);
        }
        return builder;
    }

    @Nullable
    private static String getForwardedPrefix(HttpServletRequest request) {
        String prefix = null;
        Enumeration<String> names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (!"X-Forwarded-Prefix".equalsIgnoreCase(name)) continue;
            prefix = request.getHeader(name);
        }
        if (prefix != null) {
            while (prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
        }
        return prefix;
    }

    private static String getRequestUriWithForwardedPrefix(HttpServletRequest request) {
        String path = request.getRequestURI();
        String forwardedPrefix = ServletUriComponentsBuilder.getForwardedPrefix(request);
        if (forwardedPrefix != null) {
            String contextPath = request.getContextPath();
            if (!StringUtils.isEmpty(contextPath) && !contextPath.equals("/") && path.startsWith(contextPath)) {
                path = path.substring(contextPath.length());
            }
            path = forwardedPrefix + path;
        }
        return path;
    }

    public static ServletUriComponentsBuilder fromCurrentContextPath() {
        return ServletUriComponentsBuilder.fromContextPath(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentServletMapping() {
        return ServletUriComponentsBuilder.fromServletMapping(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentRequestUri() {
        return ServletUriComponentsBuilder.fromRequestUri(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentRequest() {
        return ServletUriComponentsBuilder.fromRequest(ServletUriComponentsBuilder.getCurrentRequest());
    }

    protected static HttpServletRequest getCurrentRequest() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.state(attrs instanceof ServletRequestAttributes, "No current ServletRequestAttributes");
        return ((ServletRequestAttributes)attrs).getRequest();
    }

    private void initPath(String path) {
        this.originalPath = path;
        this.replacePath(path);
    }

    @Nullable
    public String removePathExtension() {
        String extension = null;
        if (this.originalPath != null) {
            extension = UriUtils.extractFileExtension(this.originalPath);
            if (!StringUtils.isEmpty(extension)) {
                int end = this.originalPath.length() - (extension.length() + 1);
                this.replacePath(this.originalPath.substring(0, end));
            }
            this.originalPath = null;
        }
        return extension;
    }

    @Override
    public ServletUriComponentsBuilder cloneBuilder() {
        return new ServletUriComponentsBuilder(this);
    }
}

