/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.tags;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.jsp.JspException;
import com.baidu.cloud.thirdparty.servlet.jsp.JspTagException;
import com.baidu.cloud.thirdparty.servlet.jsp.tagext.TagSupport;
import com.baidu.cloud.thirdparty.servlet.jsp.tagext.TryCatchFinally;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.servlet.support.JspAwareRequestContext;
import com.baidu.cloud.thirdparty.springframework.web.servlet.support.RequestContext;

public abstract class RequestContextAwareTag
extends TagSupport
implements TryCatchFinally {
    public static final String REQUEST_CONTEXT_PAGE_ATTRIBUTE = "com.baidu.cloud.thirdparty.springframework.web.servlet.tags.REQUEST_CONTEXT";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    @Nullable
    private RequestContext requestContext;

    public final int doStartTag() throws JspException {
        try {
            this.requestContext = (RequestContext)this.pageContext.getAttribute(REQUEST_CONTEXT_PAGE_ATTRIBUTE);
            if (this.requestContext == null) {
                this.requestContext = new JspAwareRequestContext(this.pageContext);
                this.pageContext.setAttribute(REQUEST_CONTEXT_PAGE_ATTRIBUTE, (Object)this.requestContext);
            }
            return this.doStartTagInternal();
        }
        catch (JspException | RuntimeException ex) {
            this.logger.error(ex.getMessage(), ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), ex);
            throw new JspTagException(ex.getMessage());
        }
    }

    protected final RequestContext getRequestContext() {
        Assert.state(this.requestContext != null, "No current RequestContext");
        return this.requestContext;
    }

    protected abstract int doStartTagInternal() throws Exception;

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        this.requestContext = null;
    }
}

