/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.view;

import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactoryUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.core.Ordered;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAwareOrderComparator;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.HttpMediaTypeNotAcceptableException;
import com.baidu.cloud.thirdparty.springframework.web.accept.ContentNegotiationManager;
import com.baidu.cloud.thirdparty.springframework.web.accept.ContentNegotiationManagerFactoryBean;
import com.baidu.cloud.thirdparty.springframework.web.context.request.RequestAttributes;
import com.baidu.cloud.thirdparty.springframework.web.context.request.RequestContextHolder;
import com.baidu.cloud.thirdparty.springframework.web.context.request.ServletRequestAttributes;
import com.baidu.cloud.thirdparty.springframework.web.context.request.ServletWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.context.support.WebApplicationObjectSupport;
import com.baidu.cloud.thirdparty.springframework.web.servlet.HandlerMapping;
import com.baidu.cloud.thirdparty.springframework.web.servlet.SmartView;
import com.baidu.cloud.thirdparty.springframework.web.servlet.View;
import com.baidu.cloud.thirdparty.springframework.web.servlet.ViewResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ContentNegotiatingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered,
InitializingBean {
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;
    private final ContentNegotiationManagerFactoryBean cnmFactoryBean = new ContentNegotiationManagerFactoryBean();
    private boolean useNotAcceptableStatusCode = false;
    @Nullable
    private List<View> defaultViews;
    @Nullable
    private List<ViewResolver> viewResolvers;
    private int order = Integer.MIN_VALUE;
    private static final View NOT_ACCEPTABLE_VIEW = new View(){

        @Override
        @Nullable
        public String getContentType() {
            return null;
        }

        @Override
        public void render(@Nullable Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) {
            response.setStatus(406);
        }
    };

    public void setContentNegotiationManager(@Nullable ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    @Nullable
    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setUseNotAcceptableStatusCode(boolean useNotAcceptableStatusCode) {
        this.useNotAcceptableStatusCode = useNotAcceptableStatusCode;
    }

    public boolean isUseNotAcceptableStatusCode() {
        return this.useNotAcceptableStatusCode;
    }

    public void setDefaultViews(List<View> defaultViews) {
        this.defaultViews = defaultViews;
    }

    public List<View> getDefaultViews() {
        return this.defaultViews != null ? Collections.unmodifiableList(this.defaultViews) : Collections.emptyList();
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    public List<ViewResolver> getViewResolvers() {
        return this.viewResolvers != null ? Collections.unmodifiableList(this.viewResolvers) : Collections.emptyList();
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    protected void initServletContext(ServletContext servletContext) {
        Collection<ViewResolver> matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.obtainApplicationContext(), ViewResolver.class).values();
        if (this.viewResolvers == null) {
            this.viewResolvers = new ArrayList<ViewResolver>(matchingBeans.size());
            for (ViewResolver viewResolver : matchingBeans) {
                if (this == viewResolver) continue;
                this.viewResolvers.add(viewResolver);
            }
        } else {
            for (int i = 0; i < this.viewResolvers.size(); ++i) {
                ViewResolver vr = this.viewResolvers.get(i);
                if (matchingBeans.contains(vr)) continue;
                String name = vr.getClass().getName() + i;
                this.obtainApplicationContext().getAutowireCapableBeanFactory().initializeBean(vr, name);
            }
        }
        if (this.viewResolvers.isEmpty()) {
            this.logger.warn("Did not find any ViewResolvers to delegate to; please configure them using the 'viewResolvers' property on the ContentNegotiatingViewResolver");
        }
        AnnotationAwareOrderComparator.sort(this.viewResolvers);
        this.cnmFactoryBean.setServletContext(servletContext);
    }

    @Override
    public void afterPropertiesSet() {
        if (this.contentNegotiationManager == null) {
            this.contentNegotiationManager = this.cnmFactoryBean.build();
        }
    }

    @Override
    @Nullable
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        List<View> candidateViews;
        View bestView;
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.state(attrs instanceof ServletRequestAttributes, "No current ServletRequestAttributes");
        List<MediaType> requestedMediaTypes = this.getMediaTypes(((ServletRequestAttributes)attrs).getRequest());
        if (requestedMediaTypes != null && (bestView = this.getBestView(candidateViews = this.getCandidateViews(viewName, locale, requestedMediaTypes), requestedMediaTypes, attrs)) != null) {
            return bestView;
        }
        if (this.useNotAcceptableStatusCode) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No acceptable view found; returning 406 (Not Acceptable) status code");
            }
            return NOT_ACCEPTABLE_VIEW;
        }
        this.logger.debug("No acceptable view found; returning null");
        return null;
    }

    @Nullable
    protected List<MediaType> getMediaTypes(HttpServletRequest request) {
        Assert.state(this.contentNegotiationManager != null, "No ContentNegotiationManager set");
        try {
            ServletWebRequest webRequest = new ServletWebRequest(request);
            List<MediaType> acceptableMediaTypes = this.contentNegotiationManager.resolveMediaTypes(webRequest);
            List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(request);
            LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
            for (MediaType acceptable : acceptableMediaTypes) {
                for (MediaType producible : producibleMediaTypes) {
                    if (!acceptable.isCompatibleWith(producible)) continue;
                    compatibleMediaTypes.add(this.getMostSpecificMediaType(acceptable, producible));
                }
            }
            ArrayList<MediaType> selectedMediaTypes = new ArrayList<MediaType>(compatibleMediaTypes);
            MediaType.sortBySpecificityAndQuality(selectedMediaTypes);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Requested media types are " + selectedMediaTypes + " based on Accept header types and producible media types " + producibleMediaTypes + ")");
            }
            return selectedMediaTypes;
        }
        catch (HttpMediaTypeNotAcceptableException ex) {
            return null;
        }
    }

    private List<MediaType> getProducibleMediaTypes(HttpServletRequest request) {
        Set mediaTypes = (Set)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (!CollectionUtils.isEmpty(mediaTypes)) {
            return new ArrayList<MediaType>(mediaTypes);
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        return MediaType.SPECIFICITY_COMPARATOR.compare(acceptType, produceType = produceType.copyQualityValue(acceptType)) < 0 ? acceptType : produceType;
    }

    private List<View> getCandidateViews(String viewName, Locale locale, List<MediaType> requestedMediaTypes) throws Exception {
        ArrayList<View> candidateViews = new ArrayList<View>();
        if (this.viewResolvers != null) {
            Assert.state(this.contentNegotiationManager != null, "No ContentNegotiationManager set");
            for (ViewResolver viewResolver : this.viewResolvers) {
                View view = viewResolver.resolveViewName(viewName, locale);
                if (view != null) {
                    candidateViews.add(view);
                }
                for (MediaType requestedMediaType : requestedMediaTypes) {
                    List<String> extensions = this.contentNegotiationManager.resolveFileExtensions(requestedMediaType);
                    for (String extension : extensions) {
                        String viewNameWithExtension = viewName + '.' + extension;
                        view = viewResolver.resolveViewName(viewNameWithExtension, locale);
                        if (view == null) continue;
                        candidateViews.add(view);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.defaultViews)) {
            candidateViews.addAll(this.defaultViews);
        }
        return candidateViews;
    }

    @Nullable
    private View getBestView(List<View> candidateViews, List<MediaType> requestedMediaTypes, RequestAttributes attrs) {
        for (View candidateView : candidateViews) {
            SmartView smartView;
            if (!(candidateView instanceof SmartView) || !(smartView = (SmartView)candidateView).isRedirectView()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Returning redirect view [" + candidateView + "]");
            }
            return candidateView;
        }
        for (MediaType mediaType : requestedMediaTypes) {
            for (View candidateView : candidateViews) {
                MediaType candidateContentType;
                if (!StringUtils.hasText(candidateView.getContentType()) || !mediaType.isCompatibleWith(candidateContentType = MediaType.parseMediaType(candidateView.getContentType()))) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Returning [" + candidateView + "] based on requested media type '" + mediaType + "'");
                }
                attrs.setAttribute(View.SELECTED_CONTENT_TYPE, mediaType, 0);
                return candidateView;
            }
        }
        return null;
    }
}

