/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.view.json;

import com.baidu.cloud.thirdparty.jackson.annotation.JsonView;
import com.baidu.cloud.thirdparty.jackson.core.JsonGenerator;
import com.baidu.cloud.thirdparty.jackson.databind.ObjectMapper;
import com.baidu.cloud.thirdparty.jackson.databind.ser.FilterProvider;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import com.baidu.cloud.thirdparty.springframework.http.converter.json.MappingJacksonValue;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.validation.BindingResult;
import com.baidu.cloud.thirdparty.springframework.web.servlet.view.json.AbstractJackson2View;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MappingJackson2JsonView
extends AbstractJackson2View {
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    @Deprecated
    public static final String DEFAULT_JSONP_CONTENT_TYPE = "application/javascript";
    private static final Pattern CALLBACK_PARAM_PATTERN = Pattern.compile("[0-9A-Za-z_\\.]*");
    @Nullable
    private String jsonPrefix;
    @Nullable
    private Set<String> modelKeys;
    private boolean extractValueFromSingleKeyModel = false;
    @Nullable
    private Set<String> jsonpParameterNames = new LinkedHashSet<String>();

    public MappingJackson2JsonView() {
        super((ObjectMapper)Jackson2ObjectMapperBuilder.json().build(), DEFAULT_CONTENT_TYPE);
    }

    public MappingJackson2JsonView(ObjectMapper objectMapper) {
        super(objectMapper, DEFAULT_CONTENT_TYPE);
    }

    public void setJsonPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? ")]}', " : null;
    }

    @Override
    public void setModelKey(String modelKey) {
        this.modelKeys = Collections.singleton(modelKey);
    }

    public void setModelKeys(@Nullable Set<String> modelKeys) {
        this.modelKeys = modelKeys;
    }

    @Nullable
    public final Set<String> getModelKeys() {
        return this.modelKeys;
    }

    public void setExtractValueFromSingleKeyModel(boolean extractValueFromSingleKeyModel) {
        this.extractValueFromSingleKeyModel = extractValueFromSingleKeyModel;
    }

    @Deprecated
    public void setJsonpParameterNames(Set<String> jsonpParameterNames) {
        this.jsonpParameterNames = jsonpParameterNames;
    }

    @Nullable
    private String getJsonpParameterValue(HttpServletRequest request) {
        if (this.jsonpParameterNames != null) {
            for (String name : this.jsonpParameterNames) {
                String value = request.getParameter(name);
                if (StringUtils.isEmpty(value)) continue;
                if (!this.isValidJsonpQueryParam(value)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Ignoring invalid jsonp parameter value: " + value);
                    continue;
                }
                return value;
            }
        }
        return null;
    }

    @Deprecated
    protected boolean isValidJsonpQueryParam(String value) {
        return CALLBACK_PARAM_PATTERN.matcher(value).matches();
    }

    @Override
    protected Object filterModel(Map<String, Object> model) {
        HashMap result = new HashMap(model.size());
        Set<String> modelKeys = !CollectionUtils.isEmpty(this.modelKeys) ? this.modelKeys : model.keySet();
        model.forEach((clazz, value) -> {
            if (!(value instanceof BindingResult) && modelKeys.contains(clazz) && !clazz.equals(JsonView.class.getName()) && !clazz.equals(FilterProvider.class.getName())) {
                result.put(clazz, value);
            }
        });
        return this.extractValueFromSingleKeyModel && result.size() == 1 ? result.values().iterator().next() : result;
    }

    @Override
    protected Object filterAndWrapModel(Map<String, Object> model, HttpServletRequest request) {
        Object value = super.filterAndWrapModel(model, request);
        String jsonpParameterValue = this.getJsonpParameterValue(request);
        if (jsonpParameterValue != null) {
            if (value instanceof MappingJacksonValue) {
                ((MappingJacksonValue)value).setJsonpFunction(jsonpParameterValue);
            } else {
                MappingJacksonValue container = new MappingJacksonValue(value);
                container.setJsonpFunction(jsonpParameterValue);
                value = container;
            }
        }
        return value;
    }

    @Override
    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
        if (this.jsonPrefix != null) {
            generator.writeRaw(this.jsonPrefix);
        }
        String jsonpFunction = null;
        if (object instanceof MappingJacksonValue) {
            jsonpFunction = ((MappingJacksonValue)object).getJsonpFunction();
        }
        if (jsonpFunction != null) {
            generator.writeRaw("/**/");
            generator.writeRaw(jsonpFunction + "(");
        }
    }

    @Override
    protected void writeSuffix(JsonGenerator generator, Object object) throws IOException {
        String jsonpFunction = null;
        if (object instanceof MappingJacksonValue) {
            jsonpFunction = ((MappingJacksonValue)object).getJsonpFunction();
        }
        if (jsonpFunction != null) {
            generator.writeRaw(");");
        }
    }

    @Override
    protected void setResponseContentType(HttpServletRequest request, HttpServletResponse response) {
        if (this.getJsonpParameterValue(request) != null) {
            response.setContentType(DEFAULT_JSONP_CONTENT_TYPE);
        } else {
            super.setResponseContentType(request, response);
        }
    }
}

