/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.servlet.view.tiles3;

import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.springframework.core.io.support.ResourcePatternResolver;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import com.baidu.cloud.thirdparty.springframework.web.context.support.ServletContextResourcePatternResolver;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.locale.URLApplicationResource;
import org.apache.tiles.request.servlet.ServletApplicationContext;

public class SpringWildcardServletTilesApplicationContext
extends ServletApplicationContext {
    private final ResourcePatternResolver resolver;

    public SpringWildcardServletTilesApplicationContext(ServletContext servletContext) {
        super(servletContext);
        this.resolver = new ServletContextResourcePatternResolver(servletContext);
    }

    @Nullable
    public ApplicationResource getResource(String localePath) {
        Collection<ApplicationResource> urlSet = this.getResources(localePath);
        if (!CollectionUtils.isEmpty(urlSet)) {
            return urlSet.iterator().next();
        }
        return null;
    }

    @Nullable
    public ApplicationResource getResource(ApplicationResource base, Locale locale) {
        Collection<ApplicationResource> urlSet = this.getResources(base.getLocalePath(locale));
        if (!CollectionUtils.isEmpty(urlSet)) {
            return urlSet.iterator().next();
        }
        return null;
    }

    public Collection<ApplicationResource> getResources(String path) {
        Object[] resources;
        try {
            resources = this.resolver.getResources(path);
        }
        catch (IOException ex) {
            ((ServletContext)this.getContext()).log("Resource retrieval failed for path: " + path, ex);
            return Collections.emptyList();
        }
        if (ObjectUtils.isEmpty(resources)) {
            ((ServletContext)this.getContext()).log("No resources found for path pattern: " + path);
            return Collections.emptyList();
        }
        ArrayList<ApplicationResource> resourceList = new ArrayList<ApplicationResource>(resources.length);
        for (Object resource : resources) {
            try {
                URL url = resource.getURL();
                resourceList.add((ApplicationResource)new URLApplicationResource(url.toExternalForm(), url));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("No URL for " + resource, ex);
            }
        }
        return resourceList;
    }
}

