/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.uuid;

import java.io.Serializable;

public class EthernetAddress
implements Serializable,
Cloneable,
Comparable {
    private static final String kHexChars = "0123456789abcdefABCDEF";
    private final byte[] mAddress;

    public EthernetAddress(String string) throws NumberFormatException {
        byte[] byArray = this.mAddress = new byte[6];
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < 6; ++i) {
            int n3;
            if (n2 >= n) {
                if (i == 5) {
                    byArray[5] = 0;
                    break;
                }
                throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
            }
            char c = string.charAt(n2);
            ++n2;
            if (c == ':') {
                n3 = 0;
            } else {
                if (c >= '0' && c <= '9') {
                    n3 = c - 48;
                } else if (c >= 'a' && c <= 'f') {
                    n3 = c - 97 + 10;
                } else if (c >= 'A' && c <= 'F') {
                    n3 = c - 65 + 10;
                } else {
                    throw new NumberFormatException("Non-hex character '" + c + "'");
                }
                if (n2 < n) {
                    c = string.charAt(n2);
                    ++n2;
                    if (c != ':') {
                        n3 <<= 4;
                        if (c >= '0' && c <= '9') {
                            n3 |= c - 48;
                        } else if (c >= 'a' && c <= 'f') {
                            n3 |= c - 97 + 10;
                        } else if (c >= 'A' && c <= 'F') {
                            n3 |= c - 65 + 10;
                        } else {
                            throw new NumberFormatException("Non-hex character '" + c + "'");
                        }
                    }
                }
            }
            byArray[i] = (byte)n3;
            if (c == ':') continue;
            if (n2 < n) {
                if (string.charAt(n2) != ':') {
                    throw new NumberFormatException("Expected ':', got ('" + string.charAt(n2) + "')");
                }
                ++n2;
                continue;
            }
            if (i >= 5) continue;
            throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
        }
    }

    public EthernetAddress(byte[] byArray) throws NumberFormatException {
        this.mAddress = new byte[6];
        if (byArray.length != 6) {
            throw new NumberFormatException("Ethernet address has to consist of 6 bytes");
        }
        for (int i = 0; i < 6; ++i) {
            this.mAddress[i] = byArray[i];
        }
    }

    public EthernetAddress(long l) {
        this.mAddress = new byte[6];
        for (int i = 0; i < 6; ++i) {
            this.mAddress[5 - i] = (byte)l;
            l >>>= 8;
        }
    }

    EthernetAddress() {
        this.mAddress = new byte[6];
        byte by = 0;
        for (int i = 0; i < 6; ++i) {
            this.mAddress[i] = by;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof EthernetAddress)) {
            return false;
        }
        byte[] byArray = ((EthernetAddress)object).mAddress;
        byte[] byArray2 = this.mAddress;
        for (int i = 0; i < 6; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        byte[] byArray = ((EthernetAddress)object).mAddress;
        byte[] byArray2 = this.mAddress;
        for (int i = 0; i < 6; ++i) {
            int n = (byArray2[i] & 0xFF) - (byArray[i] & 0xFF);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(17);
        byte[] byArray = this.mAddress;
        for (int i = 0; i < 6; ++i) {
            if (i > 0) {
                stringBuffer.append(":");
            }
            int n = byArray[i] & 0xFF;
            stringBuffer.append(kHexChars.charAt(n >> 4));
            stringBuffer.append(kHexChars.charAt(n & 0xF));
        }
        return stringBuffer.toString();
    }

    public byte[] asByteArray() {
        byte[] byArray = new byte[6];
        this.toByteArray(byArray);
        return byArray;
    }

    public byte[] toByteArray() {
        return this.asByteArray();
    }

    public void toByteArray(byte[] byArray) {
        this.toByteArray(byArray, 0);
    }

    public void toByteArray(byte[] byArray, int n) {
        for (int i = 0; i < 6; ++i) {
            byArray[n + i] = this.mAddress[i];
        }
    }

    public long toLong() {
        byte[] byArray = this.mAddress;
        int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        int n2 = byArray[2] & 0xFF;
        for (int i = 3; i < 6; ++i) {
            n2 = n2 << 8 | byArray[i] & 0xFF;
        }
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static EthernetAddress valueOf(byte[] byArray) throws NumberFormatException {
        return new EthernetAddress(byArray);
    }

    public static EthernetAddress valueOf(int[] nArray) throws NumberFormatException {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return new EthernetAddress(byArray);
    }

    public static EthernetAddress valueOf(String string) throws NumberFormatException {
        return new EthernetAddress(string);
    }

    public static EthernetAddress valueOf(long l) {
        return new EthernetAddress(l);
    }

    public static void main(String[] stringArray) {
        System.out.println("EthernetAddress.main, test:");
        System.out.println("---------------------------");
        long l = 0L;
        if (stringArray == null || stringArray.length == 0) {
            System.out.println("[no address passed, using a random address]");
            boolean bl = true;
            l = System.currentTimeMillis() ^ (long)(Math.random() * 4.294967296E9);
            stringArray = new String[]{new EthernetAddress(l).toString()};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            System.out.println("Address '" + string + "':");
            try {
                EthernetAddress ethernetAddress = EthernetAddress.valueOf(string);
                System.err.println("  Ok, comes out as '" + ethernetAddress.toString() + "'");
                System.err.print("  Converting to long, result = ");
                long l2 = ethernetAddress.toLong();
                System.err.println("" + Long.toHexString(l2));
                System.err.print("  Creating address from long, are equal: ");
                EthernetAddress ethernetAddress2 = EthernetAddress.valueOf(l2);
                if (!ethernetAddress2.equals(ethernetAddress)) {
                    System.err.println("no (FAIL)");
                    break;
                }
                System.err.println("yes (OK)");
                System.err.println("  Converting to byte array.");
                byte[] byArray = ethernetAddress.asByteArray();
                System.err.print("  Creating address from byte[], are equal: ");
                ethernetAddress2 = EthernetAddress.valueOf(byArray);
                if (ethernetAddress2.equals(ethernetAddress)) {
                    System.err.println("yes (OK)");
                    continue;
                }
                System.err.println("no (FAIL)");
                break;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("  Fail: " + numberFormatException.toString());
            }
        }
        System.out.println("---------------------------");
        System.out.println("Done.");
    }
}

