/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.uuid;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class Logger {
    public static final int LOG_ALL = 0;
    public static final int LOG_INFO_AND_ABOVE = 1;
    public static final int LOG_WARNING_AND_ABOVE = 2;
    public static final int LOG_ERROR_AND_ABOVE = 3;
    public static final int LOG_NOTHING = 4;
    private static Logger sInstance = new Logger();
    protected int mLogLevel = 0;
    protected PrintStream mOutput1 = System.err;
    protected PrintWriter mOutput2 = null;

    protected Logger() {
    }

    public static synchronized void setLogger(Logger logger) {
        sInstance = logger;
    }

    public static void setLogLevel(int n) {
        Logger logger = sInstance;
        if (logger != null) {
            logger.doSetLogLevel(n);
        }
    }

    public static void setOutput(PrintStream printStream) {
        Logger logger = sInstance;
        if (logger != null) {
            logger.doSetOutput(printStream);
        }
    }

    public static void setOutput(Writer writer) {
        Logger logger = sInstance;
        if (logger != null) {
            logger.doSetOutput(writer);
        }
    }

    public static void logInfo(String string) {
        Logger logger = sInstance;
        if (logger != null) {
            logger.doLogInfo(string);
        }
    }

    public static void logWarning(String string) {
        Logger logger = sInstance;
        if (logger != null) {
            logger.doLogWarning(string);
        }
    }

    public static void logError(String string) {
        Logger logger = sInstance;
        if (logger != null) {
            logger.doLogError(string);
        }
    }

    protected void doSetLogLevel(int n) {
        this.mLogLevel = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetOutput(PrintStream printStream) {
        Logger logger = this;
        synchronized (logger) {
            this.mOutput1 = printStream;
            this.mOutput2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetOutput(Writer writer) {
        Logger logger = this;
        synchronized (logger) {
            this.mOutput1 = null;
            this.mOutput2 = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLogInfo(String string) {
        if (this.mLogLevel <= 1 && this.isEnabled()) {
            Logger logger = this;
            synchronized (logger) {
                this.doWrite("INFO: " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLogWarning(String string) {
        if (this.mLogLevel <= 2 && this.isEnabled()) {
            Logger logger = this;
            synchronized (logger) {
                this.doWrite("WARNING: " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLogError(String string) {
        if (this.mLogLevel <= 3 && this.isEnabled()) {
            Logger logger = this;
            synchronized (logger) {
                this.doWrite("ERROR: " + string);
            }
        }
    }

    protected void doWrite(String string) {
        if (this.mOutput1 != null) {
            this.mOutput1.println(string);
        } else if (this.mOutput2 != null) {
            this.mOutput2.println(string);
        }
    }

    protected boolean isEnabled() {
        return this.mOutput1 != null || this.mOutput2 != null;
    }
}

