/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.uuid.ext;

import com.baidu.cloud.thirdparty.uuid.Logger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class LockedFile {
    static final int DEFAULT_LENGTH = 22;
    static final long READ_ERROR = 0L;
    final File mFile;
    RandomAccessFile mRAFile;
    FileChannel mChannel;
    FileLock mLock;
    ByteBuffer mWriteBuffer;
    boolean mWeirdSize;
    long mLastTimestamp;
    static final String HEX_DIGITS = "0123456789abcdef";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LockedFile(File file) throws IOException {
        FileLock fileLock;
        FileChannel fileChannel;
        RandomAccessFile randomAccessFile;
        block5: {
            this.mWriteBuffer = null;
            this.mLastTimestamp = 0L;
            this.mFile = file;
            randomAccessFile = null;
            fileChannel = null;
            fileLock = null;
            boolean bl = false;
            try {
                randomAccessFile = new RandomAccessFile(file, "rwd");
                fileChannel = randomAccessFile.getChannel();
                if (fileChannel == null) {
                    throw new IOException("Failed to access channel for '" + file + "'");
                }
                fileLock = fileChannel.tryLock();
                if (fileLock == null) {
                    throw new IOException("Failed to lock '" + file + "' (another JVM running UUIDGenerator?)");
                }
                bl = true;
                if (bl) break block5;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    LockedFile.doDeactivate(file, randomAccessFile, fileLock);
                }
                throw throwable;
            }
            LockedFile.doDeactivate(file, randomAccessFile, fileLock);
        }
        this.mRAFile = randomAccessFile;
        this.mChannel = fileChannel;
        this.mLock = fileLock;
    }

    public void deactivate() {
        RandomAccessFile randomAccessFile = this.mRAFile;
        this.mRAFile = null;
        FileLock fileLock = this.mLock;
        this.mLock = null;
        LockedFile.doDeactivate(this.mFile, randomAccessFile, fileLock);
    }

    public long readStamp() {
        int n;
        try {
            n = (int)this.mChannel.size();
        }
        catch (IOException iOException) {
            this.doLogError("Failed to read file size: " + iOException);
            return 0L;
        }
        boolean bl = this.mWeirdSize = n != 22;
        if (n == 0) {
            this.doLogWarning("Missing or empty file, can not read timestamp value");
            return 0L;
        }
        if (n > 100) {
            n = 100;
        }
        byte[] byArray = new byte[n];
        try {
            this.mRAFile.readFully(byArray);
        }
        catch (IOException iOException) {
            this.doLogError("Failed to read " + n + " bytes: " + iOException);
            return 0L;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        String string = new String(cArray);
        string = string.trim();
        long l = -1L;
        String string2 = null;
        if (!string.startsWith("[0") || string.length() < 3 || Character.toLowerCase(string.charAt(2)) != 'x') {
            string2 = "does not start with '[0x' prefix";
        } else {
            int n2 = string.indexOf(93, 3);
            if (n2 <= 0) {
                string2 = "does not end with ']' marker";
            } else {
                String string3 = string.substring(3, n2);
                if (string3.length() > 16) {
                    string2 = "length of the (hex) timestamp too long; expected 16, had " + string3.length() + " ('" + string3 + "')";
                } else {
                    try {
                        l = Long.parseLong(string3, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        string2 = "does not contain a valid hex timestamp; got '" + string3 + "' (parse error: " + numberFormatException + ")";
                    }
                }
            }
        }
        if (l < 0L) {
            this.doLogError("Malformed timestamp file contents: " + string2);
            return 0L;
        }
        this.mLastTimestamp = l;
        return l;
    }

    public void writeStamp(long l) throws IOException {
        if (l <= this.mLastTimestamp) {
            if (l == this.mLastTimestamp) {
                this.doLogWarning("Trying to re-write existing timestamp (" + l + ")");
                return;
            }
            throw new IOException("" + this.getFileDesc() + " trying to overwrite existing value (" + this.mLastTimestamp + ") with an earlier timestamp (" + l + ")");
        }
        if (this.mWriteBuffer == null) {
            this.mWriteBuffer = ByteBuffer.allocate(22);
            this.mWriteBuffer.put(0, (byte)91);
            this.mWriteBuffer.put(1, (byte)48);
            this.mWriteBuffer.put(2, (byte)120);
            this.mWriteBuffer.put(19, (byte)93);
            this.mWriteBuffer.put(20, (byte)13);
            this.mWriteBuffer.put(21, (byte)10);
        }
        for (int i = 18; i >= 3; --i) {
            int n = (int)l & 0xF;
            this.mWriteBuffer.put(i, (byte)HEX_DIGITS.charAt(n));
            l >>= 4;
        }
        ((Buffer)this.mWriteBuffer).position(0);
        this.mChannel.write(this.mWriteBuffer, 0L);
        if (this.mWeirdSize) {
            this.mRAFile.setLength(22L);
            this.mWeirdSize = false;
        }
        this.mChannel.force(false);
    }

    protected void doLogWarning(String string) {
        Logger.logWarning("(file '" + this.getFileDesc() + "') " + string);
    }

    protected void doLogError(String string) {
        Logger.logError("(file '" + this.getFileDesc() + "') " + string);
    }

    protected String getFileDesc() {
        return this.mFile.toString();
    }

    protected static void doDeactivate(File file, RandomAccessFile randomAccessFile, FileLock fileLock) {
        if (fileLock != null) {
            try {
                fileLock.release();
            }
            catch (Throwable throwable) {
                Logger.logError("Failed to release lock (for file '" + file + "'): " + throwable);
            }
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (Throwable throwable) {
                Logger.logError("Failed to close file '" + file + "':" + throwable);
            }
        }
    }
}

