/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client;

import com.baidu.cloud.starlight.api.rpc.StarlightClient;
import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.springcloud.client.RpcProxyFactoryBean;
import com.baidu.cloud.starlight.springcloud.client.annotation.RpcProxy;
import com.baidu.cloud.starlight.springcloud.client.cluster.FailFastClusterClient;
import com.baidu.cloud.starlight.springcloud.client.cluster.FailOverClusterClient;
import com.baidu.cloud.starlight.springcloud.client.cluster.LoadBalancer;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightRouteProperties;
import com.baidu.cloud.starlight.springcloud.configuration.Configuration;
import com.baidu.cloud.thirdparty.apache.commons.lang3.reflect.FieldUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RpcProxyAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware,
EnvironmentAware,
PriorityOrdered {
    public static final String BEAN_NAME = "rpcClientAnnotationBeanPostProcessor";
    private static final String CLIENT_BEAN_NAME_SUFFIX = ".StarlightClient";
    private static final String TARGET_NAME_PREFIX = "scopedTarget.";
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcProxyAnnotationBeanPostProcessor.class);
    private DefaultListableBeanFactory beanFactory;
    private PropertySourcesPlaceholdersResolver placeholdersResolver;

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        List fields = FieldUtils.getAllFieldsList(clazz);
        if (fields != null && fields.size() > 0) {
            for (Field field : fields) {
                RpcProxy rpcProxy = field.getAnnotation(RpcProxy.class);
                if (rpcProxy == null) continue;
                this.resolveRpcProxy(rpcProxy);
                try {
                    Object proxyBean = this.buildRpcProxyBean(field.getType(), rpcProxy);
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(bean, proxyBean);
                }
                catch (Exception e) {
                    throw new BeanCreationException(beanName, (Throwable)e);
                }
            }
        }
        return pvs;
    }

    private void resolveRpcProxy(RpcProxy rpcProxy) {
        String name = rpcProxy.name();
        if (StringUtils.isEmpty((Object)name)) {
            return;
        }
        String realName = (String)this.placeholdersResolver.resolvePlaceholders((Object)name);
        if (StringUtils.isEmpty((Object)realName)) {
            throw new IllegalArgumentException("Resolve name value of @RpcProxy#name failed, the value must not be null");
        }
        try {
            InvocationHandler rpcProxyHandler = Proxy.getInvocationHandler(rpcProxy);
            Field nameField = rpcProxyHandler.getClass().getDeclaredField("memberValues");
            nameField.setAccessible(true);
            Map memberValuesMap = (Map)nameField.get(rpcProxyHandler);
            memberValuesMap.put("name", realName);
        }
        catch (Exception e) {
            LOGGER.error("Failed to set @RpcProxy#name through reflection", (Throwable)e);
            throw new IllegalStateException("Failed to set @RpcProxy#name through reflection", e);
        }
    }

    public int getOrder() {
        return 0x7FFFFFFA;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("RpcProxyAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.placeholdersResolver = new PropertySourcesPlaceholdersResolver(environment);
    }

    private Object buildRpcProxyBean(Class<?> rpcProxyClass, RpcProxy rpcProxy) throws Exception {
        try {
            String proxyBeanName = "&" + this.proxyBeanName(rpcProxy, rpcProxyClass);
            RpcProxyFactoryBean proxyBean = (RpcProxyFactoryBean)this.beanFactory.getBean(proxyBeanName, RpcProxyFactoryBean.class);
            if (proxyBean != null) {
                return proxyBean.getObject();
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            LOGGER.info("Get Bean {} form BeanFactory failed, will create", (Object)ex.getBeanName());
        }
        return this.rpcProxyBean(rpcProxyClass, rpcProxy);
    }

    private Object rpcProxyBean(Class<?> proxyType, RpcProxy rpcProxy) throws Exception {
        String proxyBeanName;
        StarlightClient starlightClient = this.registerOrGetStarlightClient(rpcProxy);
        BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(RpcProxyFactoryBean.class);
        definitionBuilder.addPropertyValue("annotationInfos", (Object)rpcProxy);
        definitionBuilder.addPropertyValue("type", proxyType);
        definitionBuilder.addPropertyValue("client", (Object)starlightClient);
        definitionBuilder.addPropertyValue("clientProperties", (Object)this.clientProperties());
        definitionBuilder.setAutowireMode(2);
        AbstractBeanDefinition beanDefinition = definitionBuilder.getBeanDefinition();
        String aliasName = proxyBeanName = this.proxyBeanName(rpcProxy, proxyType);
        if (StringUtils.hasText((String)rpcProxy.qualifier())) {
            aliasName = rpcProxy.qualifier();
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, proxyBeanName, new String[]{aliasName});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)this.beanFactory);
        RpcProxyFactoryBean proxyBean = (RpcProxyFactoryBean)this.beanFactory.getBean("&" + proxyBeanName, RpcProxyFactoryBean.class);
        return proxyBean.getObject();
    }

    private StarlightClient registerOrGetStarlightClient(RpcProxy rpcProxy) {
        String clientBeanName = this.clientBeanName(rpcProxy);
        if (!StringUtils.isEmpty((Object)rpcProxy.remoteUrl())) {
            String protocol = null;
            if (rpcProxy.remoteUrl().contains("://")) {
                protocol = rpcProxy.remoteUrl().split("://")[0];
            }
            if (StringUtils.isEmpty((Object)rpcProxy.protocol()) && StringUtils.isEmpty(protocol)) {
                throw new IllegalArgumentException("protocol in @RpcProxy#protocol is null, when specify @RpcProxy#remoteUrl");
            }
            return this.registerOrGetSingleClient(clientBeanName, rpcProxy);
        }
        if (!StringUtils.isEmpty((Object)rpcProxy.name())) {
            return this.registerOrGetClusterClient(clientBeanName, rpcProxy);
        }
        return null;
    }

    private StarlightClient registerOrGetSingleClient(String clientBeanName, RpcProxy rpcProxy) {
        StarlightClient starlightClient = this.getClientFormIocCache(clientBeanName);
        if (starlightClient != null) {
            return starlightClient;
        }
        String remoteUrl = rpcProxy.remoteUrl();
        if (remoteUrl.contains("://")) {
            remoteUrl = remoteUrl.split("://")[1];
        }
        String[] ipAndPort = remoteUrl.split(":");
        StarlightClientProperties properties = this.clientProperties();
        BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SingleStarlightClient.class);
        definitionBuilder.addConstructorArgValue((Object)ipAndPort[0]);
        definitionBuilder.addConstructorArgValue((Object)ipAndPort[1]);
        definitionBuilder.addConstructorArgValue((Object)properties.transportConfig(remoteUrl));
        definitionBuilder.setInitMethodName("init");
        definitionBuilder.setDestroyMethodName("destroy");
        definitionBuilder.setAutowireMode(2);
        AbstractBeanDefinition beanDefinition = definitionBuilder.getBeanDefinition();
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, clientBeanName, new String[]{clientBeanName});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)this.beanFactory);
        return (StarlightClient)this.beanFactory.getBean(clientBeanName, StarlightClient.class);
    }

    private StarlightClient registerOrGetClusterClient(String clientBeanName, RpcProxy rpcProxy) {
        StarlightClient starlightClient = this.getClientFormIocCache(clientBeanName);
        if (starlightClient != null) {
            return starlightClient;
        }
        StarlightClientProperties properties = this.clientProperties();
        String clusterModel = this.clusterModel(properties, rpcProxy);
        BeanDefinitionBuilder definitionBuilder = null;
        switch (clusterModel) {
            case "failfast": {
                definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(FailFastClusterClient.class);
                break;
            }
            case "failover": {
                definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(FailOverClusterClient.class);
                break;
            }
            default: {
                throw new IllegalStateException("starlight.client.config {clusterModel} is null, please config it before run");
            }
        }
        LoadBalancer loadBalancer = (LoadBalancer)this.beanFactory.getBean(LoadBalancer.class);
        DiscoveryClient discoveryClient = (DiscoveryClient)this.beanFactory.getBean(DiscoveryClient.class);
        SingleStarlightClientManager clientManager = (SingleStarlightClientManager)this.beanFactory.getBean(SingleStarlightClientManager.class);
        Configuration configuration = null;
        try {
            configuration = (Configuration)this.beanFactory.getBean(Configuration.class);
        }
        catch (BeansException e) {
            LOGGER.error("No such bean of Configuration, does not depend on gravity?", (Throwable)e);
        }
        StarlightRouteProperties routeProperties = (StarlightRouteProperties)this.beanFactory.getBean(StarlightRouteProperties.class);
        definitionBuilder.addConstructorArgValue((Object)rpcProxy.name());
        definitionBuilder.addConstructorArgValue((Object)properties);
        definitionBuilder.addConstructorArgValue((Object)loadBalancer);
        definitionBuilder.addConstructorArgValue((Object)discoveryClient);
        definitionBuilder.addConstructorArgValue((Object)clientManager);
        definitionBuilder.addConstructorArgValue((Object)configuration);
        definitionBuilder.addConstructorArgValue((Object)routeProperties);
        definitionBuilder.setInitMethodName("init");
        definitionBuilder.setDestroyMethodName("destroy");
        definitionBuilder.setAutowireMode(2);
        AbstractBeanDefinition beanDefinition = definitionBuilder.getBeanDefinition();
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, clientBeanName, new String[]{clientBeanName});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)this.beanFactory);
        return (StarlightClient)this.beanFactory.getBean(clientBeanName, StarlightClient.class);
    }

    private StarlightClientProperties clientProperties() {
        StarlightClientProperties properties = (StarlightClientProperties)this.beanFactory.getBean(StarlightClientProperties.class);
        if (properties.getConfig() == null || properties.getConfig().size() == 0) {
            throw new IllegalStateException("starlight.client.config is null, please config it before run");
        }
        return properties;
    }

    private String clusterModel(StarlightClientProperties properties, RpcProxy rpcProxy) {
        String clusterModel = properties.getClusterModel(rpcProxy.name());
        if (StringUtils.isEmpty((Object)clusterModel)) {
            throw new IllegalStateException("starlight.client.config {clusterModel} is null, please config it before run");
        }
        return clusterModel;
    }

    private String clientBeanName(RpcProxy rpcProxy) {
        String remoteUrl = rpcProxy.remoteUrl();
        if (!remoteUrl.isEmpty()) {
            if (remoteUrl.contains("://")) {
                remoteUrl = remoteUrl.split("://")[1];
            }
            return remoteUrl + CLIENT_BEAN_NAME_SUFFIX;
        }
        String name = rpcProxy.name();
        if (!name.isEmpty()) {
            return name + CLIENT_BEAN_NAME_SUFFIX;
        }
        throw new IllegalStateException("Either name() or remoteUrl() must be provided in @" + RpcProxy.class.getSimpleName());
    }

    private String proxyBeanName(RpcProxy rpcProxy, Class<?> proxyType) {
        StringBuilder buf = new StringBuilder(TARGET_NAME_PREFIX + this.clientBeanName(rpcProxy) + ".");
        if (!StringUtils.isEmpty((Object)rpcProxy.protocol())) {
            buf.append(rpcProxy.protocol()).append(".");
        }
        buf.append(proxyType.getName());
        return buf.toString();
    }

    private StarlightClient getClientFormIocCache(String clientBeanName) {
        StarlightClient starlightClient = null;
        try {
            starlightClient = (StarlightClient)this.beanFactory.getBean(clientBeanName, StarlightClient.class);
        }
        catch (BeansException e) {
            if (e instanceof NoSuchBeanDefinitionException) {
                LOGGER.info("Get bean {" + clientBeanName + "} failed, will create.");
            }
            throw e;
        }
        return starlightClient;
    }
}

