/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster;

import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.rpc.RpcContext;
import com.baidu.cloud.starlight.api.rpc.StarlightClient;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.rpc.config.TransportConfig;
import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.springcloud.client.cluster.Cluster;
import com.baidu.cloud.starlight.springcloud.client.cluster.LoadBalancer;
import com.baidu.cloud.starlight.springcloud.client.cluster.RequestContext;
import com.baidu.cloud.starlight.springcloud.client.cluster.Router;
import com.baidu.cloud.starlight.springcloud.client.cluster.RouterChain;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.label.LabelClusterSelector;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.label.LabelSelectorRouter;
import com.baidu.cloud.starlight.springcloud.client.properties.OutlierConfig;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightRouteProperties;
import com.baidu.cloud.starlight.springcloud.common.ApplicationContextUtils;
import com.baidu.cloud.starlight.springcloud.common.SpringCloudConstants;
import com.baidu.cloud.starlight.springcloud.configuration.Configuration;
import com.baidu.cloud.thirdparty.netty.util.Timeout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public abstract class AbstractClusterClient
implements StarlightClient {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final LoadBalancer loadBalancer;
    private final DiscoveryClient discoveryClient;
    protected final StarlightClientProperties properties;
    private final SingleStarlightClientManager clientManager;
    private final Map<Class<?>, ServiceConfig> serviceConfigs;
    private final TransportConfig transportConfig;
    private volatile PeerStatus peerStatus;
    private final Map<Request, AtomicInteger> netErrorRetryTimes;
    private RouterChain routerChain;
    private Configuration configuration;
    private StarlightRouteProperties routeProperties;
    private Set<ServiceInstance> initedInstances = new HashSet<ServiceInstance>();

    public AbstractClusterClient(String name, StarlightClientProperties properties, LoadBalancer loadBalancer, DiscoveryClient discoveryClient, SingleStarlightClientManager clientManager, Configuration configuration, StarlightRouteProperties routeProperties) {
        this.name = name;
        this.properties = properties;
        this.loadBalancer = loadBalancer;
        this.discoveryClient = discoveryClient;
        this.serviceConfigs = new ConcurrentHashMap();
        this.transportConfig = properties.transportConfig(name);
        this.clientManager = clientManager;
        this.configuration = configuration;
        this.routeProperties = routeProperties;
        this.netErrorRetryTimes = new ConcurrentHashMap<Request, AtomicInteger>();
    }

    public String getName() {
        return this.name;
    }

    public void init() {
        this.LOGGER.info("Init starlight client {}", (Object)this.getName());
        if (this.properties.getWarmUpEnabled(this.getName()).booleanValue()) {
            this.LOGGER.info("Warm up starlight client {}", (Object)this.getName());
            List instances = this.discoveryClient.getInstances(this.name);
            if (instances != null && instances.size() > 0) {
                int warmUpCount = this.warmUpSize(instances.size());
                for (int i = 0; i < warmUpCount; ++i) {
                    try {
                        ServiceInstance serviceInstance = (ServiceInstance)instances.get(i);
                        this.initSingleClient(serviceInstance.getHost(), serviceInstance.getPort());
                        this.initedInstances.add(serviceInstance);
                        continue;
                    }
                    catch (Exception e) {
                        this.LOGGER.error("Failed to init SingleClient in ClusterClient#init() method, will retry to init in ClusterClient#request() method", (Throwable)e);
                    }
                }
            }
        }
        LabelSelectorRouter selectorRouter = new LabelSelectorRouter(this.getName(), this.routeProperties, this.properties, this.loadBalancer);
        ArrayList<Router> routes = new ArrayList<Router>();
        if (this.routeProperties != null && this.routeProperties.getEnabled().booleanValue()) {
            routes.add(selectorRouter);
        } else {
            this.LOGGER.info("Will not execute xds route because route.enabled is false");
        }
        this.routerChain = new RouterChain(routes, selectorRouter);
        this.peerStatus = new PeerStatus(PeerStatus.Status.ACTIVE, Long.valueOf(System.currentTimeMillis()));
    }

    protected SingleStarlightClient initSingleClient(String host, Integer port) {
        OutlierConfig outlierConfig = this.properties.getOutlierConfig(this.getName());
        if (outlierConfig != null) {
            HashMap<String, String> transConfigAdd = new HashMap<String, String>();
            transConfigAdd.put("outlier_detect_enabled", String.valueOf(outlierConfig.getEnabled()));
            transConfigAdd.put("outlier_detect_interval", String.valueOf(outlierConfig.getDetectInterval()));
            transConfigAdd.put("outlier_detect_mini_request_num", String.valueOf(outlierConfig.getFailurePercentMinRequest()));
            transConfigAdd.put("outlier_detect_fail_percent_threshold", String.valueOf(outlierConfig.getFailurePercentThreshold()));
            if (outlierConfig.getFailureCountThreshold() != null) {
                transConfigAdd.put("outlier_detect_fail_count_threshold", String.valueOf(outlierConfig.getFailureCountThreshold()));
            }
            this.transportConfig.setAdditional(transConfigAdd);
        }
        return this.clientManager.getOrCreateSingleClient(host, port, this.transportConfig);
    }

    public void request(Request request, RpcCallback callback) {
        callback = new NetworkErrorRetryCallback(callback);
        this.addNetErrorRetryTimes(request);
        this.addProviderAppName(request);
        boolean labelRouter = false;
        RequestContext requestContext = new RequestContext(request, RpcContext.getContext());
        try {
            Cluster cluster = this.routerChain.route(requestContext);
            if (cluster.getClusterSelector() instanceof LabelClusterSelector) {
                labelRouter = true;
            }
            cluster.setServiceRefers(this.serviceConfigs);
            cluster.execute(request, callback);
        }
        catch (Throwable e) {
            if (this.routeProperties.getNoInstanceFallBack() == null || !this.routeProperties.getNoInstanceFallBack().booleanValue()) {
                this.LOGGER.error("Request failed and cannot fallback, req:{}#{}, caused by", new Object[]{request.getServiceName(), request.getMethodName(), e});
                throw e;
            }
            if (e instanceof StarlightRpcException && SpringCloudConstants.NO_INSTANCE_ERROR_CODE.equals(((StarlightRpcException)e).getCode()) && !labelRouter) {
                this.LOGGER.info("No instance found from the routed cluster, fallback to the label selector route");
                Cluster cluster = this.routerChain.noneRoute(requestContext);
                cluster.setServiceRefers(this.serviceConfigs);
                cluster.execute(request, callback);
            }
            this.LOGGER.error("Request failed, req:{}#{}, caused by", new Object[]{request.getServiceName(), request.getMethodName(), e});
            throw e;
        }
    }

    public void refer(Class<?> serviceClass, ServiceConfig serviceConfig) {
        if (this.serviceConfigs.get(serviceClass) == null) {
            this.LOGGER.info("Refer service class {}", (Object)serviceClass.getName());
            this.serviceConfigs.put(serviceClass, serviceConfig);
            for (ServiceInstance instance : this.initedInstances) {
                SingleStarlightClient client = this.clientManager.getSingleClient(instance.getHost(), instance.getPort());
                if (client == null) continue;
                client.refer(serviceClass, serviceConfig);
            }
        }
    }

    public void destroy() {
        if (this.serviceConfigs != null && this.serviceConfigs.size() > 0) {
            this.serviceConfigs.clear();
        }
    }

    private int warmUpSize(Integer instanceSize) {
        Integer warmUpRatio = this.properties.getWarmUpRatio(this.getName());
        Integer warmUpCount = this.properties.getWarmUpCount(this.getName());
        if (warmUpCount != null) {
            return warmUpCount;
        }
        if (warmUpRatio != null) {
            return instanceSize * warmUpRatio / 100;
        }
        return instanceSize;
    }

    private void addNetErrorRetryTimes(Request request) {
        this.netErrorRetryTimes.putIfAbsent(request, new AtomicInteger(this.properties.getNetworkErrorRetryTimes(this.getName())));
    }

    private void removeNetErrorRetryTimes(Request request) {
        this.netErrorRetryTimes.remove(request);
    }

    private void addProviderAppName(Request request) {
        if (request.getAttachmentKv() == null) {
            request.setAttachmentKv(new HashMap());
        }
        request.getAttachmentKv().put("provider_app_name", this.getName());
        try {
            request.getAttachmentKv().put("consumer_app_name", ApplicationContextUtils.getApplicationName());
        }
        catch (Exception e) {
            this.LOGGER.warn("Get appName failed, do not need to pay attention, appName will be used for logging. msg {}", (Object)e.getMessage());
        }
    }

    public boolean isActive() {
        for (Map.Entry<String, SingleStarlightClient> entry : this.clientManager.allSingleClients().entrySet()) {
            if (!entry.getValue().isActive()) continue;
            return true;
        }
        return false;
    }

    public PeerStatus getStatus() {
        return this.peerStatus;
    }

    public void updateStatus(PeerStatus newStatus) {
        throw new RuntimeException("ClusterStarlightClient not support update status");
    }

    public URI remoteURI() {
        throw new UnsupportedOperationException("Get remoteURI is not support in AbstractClusterClient");
    }

    private class NetworkErrorRetryCallback
    implements RpcCallback {
        private final RpcCallback chainedCallback;

        public NetworkErrorRetryCallback(RpcCallback callback) {
            this.chainedCallback = callback;
        }

        public void addTimeout(Timeout timeout) {
            this.chainedCallback.addTimeout(timeout);
        }

        public Request getRequest() {
            return this.chainedCallback.getRequest();
        }

        public void onResponse(Response response) {
            AbstractClusterClient.this.removeNetErrorRetryTimes(this.getRequest());
            this.chainedCallback.onResponse((Object)response);
        }

        public void onError(Throwable e) {
            if (e instanceof TransportException && AbstractClusterClient.this.netErrorRetryTimes.get(this.getRequest()) == null) {
                AbstractClusterClient.this.LOGGER.warn("Request to {} failed caused by network error {}, configured retryTimes {}, reqId {}, mapSize {}", new Object[]{this.getRequest().getRemoteURI().getAddress(), ((TransportException)e).getCode(), AbstractClusterClient.this.netErrorRetryTimes.get(this.getRequest()), this.getRequest().getId(), AbstractClusterClient.this.netErrorRetryTimes.size()});
            }
            if (e instanceof TransportException && AbstractClusterClient.this.netErrorRetryTimes.get(this.getRequest()) != null) {
                int retryTimes = ((AtomicInteger)AbstractClusterClient.this.netErrorRetryTimes.get(this.getRequest())).getAndDecrement();
                if (retryTimes > 0) {
                    AbstractClusterClient.this.LOGGER.info("Request to {} failed because network error will retry {}", (Object)this.getRequest().getRemoteURI().getAddress(), (Object)retryTimes);
                    AbstractClusterClient.this.request(this.getRequest(), this.chainedCallback);
                } else {
                    AbstractClusterClient.this.removeNetErrorRetryTimes(this.getRequest());
                    this.chainedCallback.onError(e);
                }
            } else {
                AbstractClusterClient.this.removeNetErrorRetryTimes(this.getRequest());
                this.chainedCallback.onError(e);
            }
        }
    }
}

