/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster;

import com.baidu.cloud.starlight.api.exception.RpcException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.utils.LogUtils;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.springcloud.client.cluster.AbstractClusterClient;
import com.baidu.cloud.starlight.springcloud.client.cluster.LoadBalancer;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightRouteProperties;
import com.baidu.cloud.starlight.springcloud.configuration.Configuration;
import com.baidu.cloud.thirdparty.netty.util.Timeout;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class FailOverClusterClient
extends AbstractClusterClient {
    private final Map<Request, AtomicInteger> remainedRetries = new ConcurrentHashMap<Request, AtomicInteger>();
    private final Map<Request, Integer> retryTimesMap = new ConcurrentHashMap<Request, Integer>();

    public FailOverClusterClient(String name, StarlightClientProperties properties, LoadBalancer loadBalancer, DiscoveryClient discoveryClient, SingleStarlightClientManager clientManager, Configuration configuration, StarlightRouteProperties routeProperties) {
        super(name, properties, loadBalancer, discoveryClient, clientManager, configuration, routeProperties);
    }

    @Override
    public void request(Request request, RpcCallback callback) {
        Integer retryTimes = this.retryTimes(request);
        if (retryTimes == null || retryTimes <= 0) {
            retryTimes = 0;
        }
        this.remainedRetries.putIfAbsent(request, new AtomicInteger(retryTimes));
        this.retryTimesMap.putIfAbsent(request, retryTimes);
        super.request(request, new FailOverClusterCallback(callback));
    }

    private Integer retryTimes(Request request) {
        return this.properties.getRetryTimes(this.getName(), request.getServiceClass().getName());
    }

    private boolean isRetryable(Request request) {
        String[] retryableMethodList;
        String retryableMethods = this.properties.getRetryMethods(this.getName(), request.getServiceClass().getName());
        if (StringUtils.isEmpty((String)retryableMethods)) {
            return false;
        }
        for (String method : retryableMethodList = retryableMethods.split(",")) {
            if (!request.getMethodName().startsWith(method)) continue;
            return true;
        }
        return false;
    }

    private boolean isRetryable(RpcException rpcException, Request request) {
        String[] retryableCodeList;
        String retryErrorCodes = this.properties.getRetryErrorCodes(this.getName(), request.getServiceClass().getName());
        if (StringUtils.isEmpty((String)retryErrorCodes)) {
            return false;
        }
        Integer code = rpcException.getCode();
        if (code == null) {
            return false;
        }
        String strCode = String.valueOf(code);
        for (String errCode : retryableCodeList = retryErrorCodes.split(",")) {
            if (!strCode.equals(errCode)) continue;
            return true;
        }
        return false;
    }

    private Integer retryDelayTimeUnitMills(Request request) {
        return this.properties.getRetryDelayTimeUnitMills(this.getName(), request.getServiceClass().getName());
    }

    private void clearRetryTimesCache(Request request) {
        this.retryTimesMap.remove(request);
        this.remainedRetries.remove(request);
    }

    protected class FailOverClusterCallback
    implements RpcCallback {
        private final RpcCallback chainedCallback;

        public FailOverClusterCallback(RpcCallback callback) {
            this.chainedCallback = callback;
        }

        public void addTimeout(Timeout timeout) {
            this.chainedCallback.addTimeout(timeout);
        }

        public Request getRequest() {
            return this.chainedCallback.getRequest();
        }

        public void onResponse(Response response) {
            Integer canRetryTimes = (Integer)FailOverClusterClient.this.retryTimesMap.get(this.getRequest());
            AtomicInteger remindRetryTimes = (AtomicInteger)FailOverClusterClient.this.remainedRetries.get(this.getRequest());
            if (canRetryTimes != null && remindRetryTimes != null && !canRetryTimes.equals(remindRetryTimes.get())) {
                FailOverClusterClient.this.LOGGER.info("[FailOver] Request retry success: serviceName {}, methodName {}, traceId {}, retryCount {}", new Object[]{this.getRequest().getServiceName(), this.getRequest().getMethodName(), LogUtils.parseTraceIdSpanId((Request)this.getRequest()).get("tcid"), canRetryTimes - remindRetryTimes.get()});
            }
            FailOverClusterClient.this.clearRetryTimesCache(this.getRequest());
            this.chainedCallback.onResponse((Object)response);
        }

        public void onError(Throwable e) {
            RpcException rpcException;
            Request request = this.getRequest();
            if (!(e instanceof RpcException)) {
                FailOverClusterClient.this.clearRetryTimesCache(request);
                this.chainedCallback.onError(e);
            }
            if (!FailOverClusterClient.this.isRetryable(rpcException = (RpcException)e, request)) {
                FailOverClusterClient.this.clearRetryTimesCache(request);
                this.chainedCallback.onError(e);
                return;
            }
            if (!FailOverClusterClient.this.isRetryable(request)) {
                FailOverClusterClient.this.clearRetryTimesCache(this.getRequest());
                this.chainedCallback.onError(e);
                return;
            }
            AtomicInteger remindRetryTimes = (AtomicInteger)FailOverClusterClient.this.remainedRetries.get(request);
            if (remindRetryTimes == null || remindRetryTimes.get() <= 0) {
                FailOverClusterClient.this.LOGGER.warn("[FailOver] Request failed will not retry, reach the max retry times: serviceName {}, methodName{}, traceId {}", new Object[]{request.getServiceName(), request.getMethodName(), LogUtils.parseTraceIdSpanId((Request)request).get("tcid")});
                FailOverClusterClient.this.clearRetryTimesCache(request);
                this.chainedCallback.onError(e);
                return;
            }
            FailOverClusterClient.this.LOGGER.warn("[FailOver] Request failed will retry: errorCode {}, serviceName {}, methodName {}, traceId {}, retryNo {}, exception {}. ", new Object[]{rpcException.getCode(), request.getServiceName(), request.getMethodName(), LogUtils.parseTraceIdSpanId((Request)request).get("tcid"), remindRetryTimes.get(), e.getMessage()});
            try {
                int retryDelayInterval = FailOverClusterClient.this.retryDelayTimeUnitMills(request) * ((Integer)FailOverClusterClient.this.retryTimesMap.get(request) - remindRetryTimes.get());
                TimeUnit.MILLISECONDS.sleep(retryDelayInterval);
            }
            catch (InterruptedException interruptedException) {
                FailOverClusterClient.this.LOGGER.error("The delay between two retries was interrupted, this should not happen", (Throwable)interruptedException);
            }
            remindRetryTimes.decrementAndGet();
            FailOverClusterClient.this.request(this.getRequest(), this.chainedCallback);
        }
    }
}

