/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster;

import com.baidu.cloud.starlight.springcloud.client.cluster.Cluster;
import com.baidu.cloud.starlight.springcloud.client.cluster.RequestContext;
import com.baidu.cloud.starlight.springcloud.client.cluster.Router;
import com.baidu.cloud.starlight.springcloud.common.RouteUtils;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterChain.class);
    private List<Router> routers;
    private Router noneRouter;

    public RouterChain(List<Router> routers, Router noneRouter) {
        if (routers != null && routers.size() > 1) {
            Collections.sort(routers);
        }
        this.routers = routers;
        this.noneRouter = noneRouter;
    }

    public Cluster route(RequestContext requestContext) {
        if (this.routers == null || this.routers.size() == 0) {
            return this.noneRoute(requestContext);
        }
        for (Router router : this.routers) {
            Cluster cluster = router.route(requestContext);
            if (cluster == null) continue;
            return cluster;
        }
        return this.noneRoute(requestContext);
    }

    public Cluster noneRoute(RequestContext requestContext) {
        LOGGER.info("[NONE_ROUTE] Request matched none route: req {}, routeClass {}", (Object)RouteUtils.reqMsg(requestContext.getRequest()), (Object)this.noneRouter.getClass().getSimpleName());
        return this.noneRouter.route(requestContext);
    }
}

