/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster;

import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.rpc.config.TransportConfig;
import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.springcloud.common.InstanceUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleStarlightClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleStarlightClientManager.class);
    private final Map<String, SingleStarlightClient> starlightClients = new ConcurrentHashMap<String, SingleStarlightClient>();
    private static SingleStarlightClientManager clientManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SingleStarlightClientManager getInstance() {
        if (clientManager != null) return clientManager;
        Class<SingleStarlightClientManager> clazz = SingleStarlightClientManager.class;
        synchronized (SingleStarlightClientManager.class) {
            if (clientManager != null) return clientManager;
            clientManager = new SingleStarlightClientManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return clientManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleStarlightClient getOrCreateSingleClient(String host, Integer port, TransportConfig config, Map<Class<?>, ServiceConfig> serviceConfigs) {
        SingleStarlightClient client = this.getAliveSingleClient(host, port);
        if (client != null) {
            if (serviceConfigs != null && serviceConfigs.size() > 0) {
                for (Map.Entry<Class<?>, ServiceConfig> entry : serviceConfigs.entrySet()) {
                    client.refer(entry.getKey(), entry.getValue());
                }
            }
            return client;
        }
        SingleStarlightClientManager singleStarlightClientManager = this;
        synchronized (singleStarlightClientManager) {
            client = this.getAliveSingleClient(host, port);
            if (client != null) {
                return client;
            }
            client = this.createSingleClient(host, port, config);
            if (serviceConfigs != null && serviceConfigs.size() > 0) {
                for (Map.Entry<Class<?>, ServiceConfig> entry : serviceConfigs.entrySet()) {
                    client.refer(entry.getKey(), entry.getValue());
                }
            }
            String clientId = InstanceUtils.ipPortStr(host, port);
            this.starlightClients.put(clientId, client);
        }
        return client;
    }

    public SingleStarlightClient getOrCreateSingleClient(String host, Integer port, TransportConfig config) {
        return this.getOrCreateSingleClient(host, port, config, null);
    }

    protected SingleStarlightClient createSingleClient(String host, Integer port, TransportConfig config) {
        SingleStarlightClient singleClient = new SingleStarlightClient(host, port, config);
        singleClient.init();
        return singleClient;
    }

    public SingleStarlightClient getSingleClient(String host, Integer port) {
        return this.starlightClients.get(InstanceUtils.ipPortStr(host, port));
    }

    public SingleStarlightClient getAliveSingleClient(String host, Integer port) {
        SingleStarlightClient client = this.getSingleClient(host, port);
        if (client == null) {
            return null;
        }
        if (client.isActive()) {
            return client;
        }
        if (client.getStatus() != null && PeerStatus.Status.OUTLIER.equals((Object)client.getStatus().getStatus())) {
            return client;
        }
        return null;
    }

    public void removeSingleClient(String host, Integer port) {
        SingleStarlightClient client = this.starlightClients.remove(InstanceUtils.ipPortStr(host, port));
        if (client != null) {
            LOGGER.info("Remove and destroy inactive SingleStarlightClient from StarlightClientManager, host {}, port {}, isActive {}", new Object[]{host, port, client.isActive()});
            client.destroy();
        }
    }

    public Map<String, SingleStarlightClient> allSingleClients() {
        return this.starlightClients;
    }

    public void destroyAll() {
        for (Map.Entry<String, SingleStarlightClient> entry : this.starlightClients.entrySet()) {
            entry.getValue().destroy();
        }
        this.starlightClients.clear();
    }
}

