/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster.loadbalance;

import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.rpc.RpcContext;
import com.baidu.cloud.starlight.api.rpc.StarlightClient;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.springcloud.client.cluster.ClusterSelector;
import com.baidu.cloud.starlight.springcloud.client.cluster.LoadBalancer;
import com.baidu.cloud.starlight.springcloud.client.cluster.StarlightLBRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;

public class SpringCloudLoadbalancer
implements LoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCloudLoadbalancer.class);
    private LoadBalancerClient loadBalancerClient;

    public SpringCloudLoadbalancer(LoadBalancerClient loadBalancerClient) {
        this.loadBalancerClient = loadBalancerClient;
    }

    @Override
    public ServiceInstance choose(ClusterSelector clusterSelector) {
        long chooseStart = System.currentTimeMillis();
        RpcContext.getContext().set("req_route_meta", (Object)clusterSelector);
        ServiceInstance instance = this.loadBalancerClient.choose(clusterSelector.getServiceId());
        RpcContext.getContext().remove("req_route_meta");
        LOGGER.debug("Spring cloud loadblancer choose instance for {} cost {}", (Object)clusterSelector.getServiceId(), (Object)(System.currentTimeMillis() - chooseStart));
        return instance;
    }

    @Override
    public void execute(ClusterSelector clusterSelector, SingleStarlightClient starlightClient, ServiceInstance instance, Request request, RpcCallback callback) {
        try {
            this.loadBalancerClient.execute(clusterSelector.getServiceId(), instance, (LoadBalancerRequest)new StarlightLBRequest((StarlightClient)starlightClient, request, callback));
        }
        catch (Throwable e) {
            throw new StarlightRpcException("Failed to execute request in loadbalancer, instance " + instance.getHost() + ":" + instance.getPort(), e);
        }
    }
}

