/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster.route.label;

import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.springcloud.client.cluster.Cluster;
import com.baidu.cloud.starlight.springcloud.client.cluster.LoadBalancer;
import com.baidu.cloud.starlight.springcloud.client.cluster.RequestContext;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.AbstractRouter;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.label.LabelClusterSelector;
import com.baidu.cloud.starlight.springcloud.client.cluster.subcluster.DefaultCluster;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightRouteProperties;
import com.baidu.cloud.starlight.springcloud.common.RouteUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelSelectorRouter
extends AbstractRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelSelectorRouter.class);
    private static final Integer PRIORITY = 0x7FFFFFFE;
    private final String serviceId;
    private final LoadBalancer loadBalancer;
    private final StarlightRouteProperties routeProperties;
    private final StarlightClientProperties clientProperties;

    public LabelSelectorRouter(String serviceId, StarlightRouteProperties routeProperties, StarlightClientProperties clientProperties, LoadBalancer loadBalancer) {
        this.serviceId = serviceId;
        this.routeProperties = routeProperties;
        this.clientProperties = clientProperties;
        this.loadBalancer = loadBalancer;
    }

    @Override
    public Cluster route(RequestContext requestContext) {
        long routeStart = System.currentTimeMillis();
        String labelSelector = this.routeProperties.getServiceLabelSelector(this.getServiceId());
        if (StringUtils.isEmpty((String)labelSelector)) {
            LOGGER.debug("[LABEL_ROUTE]LabelSelector for service {} is empty", (Object)this.getServiceId());
            labelSelector = "";
        }
        LabelClusterSelector clusterSelector = new LabelClusterSelector();
        clusterSelector.setServiceId(this.getServiceId());
        clusterSelector.setClusterName(this.getServiceId());
        HashMap<String, String> clusterLabels = new HashMap<String, String>();
        clusterLabels.put("label_selector_route", labelSelector);
        clusterSelector.setMeta(clusterLabels);
        this.recordRouteMatch(requestContext, labelSelector, routeStart);
        return new DefaultCluster(clusterSelector, this.clientProperties, this.loadBalancer);
    }

    @Override
    public int getPriority() {
        return PRIORITY;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    private void recordRouteMatch(RequestContext reqContext, String labelSelector, long routeStart) {
        LOGGER.info("[LABEL_ROUTE] Request matched label-selector route: serviceId {}, req{}, labelSelector {}, cost {}", new Object[]{this.getServiceId(), RouteUtils.reqMsg(reqContext.getRequest()), labelSelector, System.currentTimeMillis() - routeStart});
    }
}

