/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster.route.label.match;

import com.baidu.cloud.starlight.springcloud.client.cluster.route.label.match.LabelOperator;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.label.match.LabelSelector;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.label.match.LabelSelectorRequirement;
import com.baidu.cloud.thirdparty.apache.commons.lang3.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class LabelParser {
    public LabelSelector parse(String label) {
        if (StringUtils.isEmpty((CharSequence)label)) {
            return null;
        }
        String[] labels = label.split("&&");
        List<LabelSelectorRequirement> lsr = Arrays.stream(labels).map(this::doParse).filter(Objects::nonNull).collect(Collectors.toList());
        LabelSelector ls = new LabelSelector();
        ls.setMatchExpressions(lsr);
        return ls;
    }

    private LabelSelectorRequirement doParse(String label) {
        label = label.trim();
        for (LabelOperator operator : LabelOperator.values()) {
            if (!label.contains(operator.getOperator())) continue;
            String[] labelSplit = label.split(operator.getOperator(), 2);
            if (labelSplit.length != 2) {
                return null;
            }
            String lhs = labelSplit[0].trim();
            String rhs = labelSplit[1].trim();
            rhs = rhs.replaceAll("^\\(", "").replaceAll("\\)$", "");
            LabelSelectorRequirement ls = new LabelSelectorRequirement();
            ls.setKey(lhs);
            ls.setOperator(operator);
            ls.setValues(Arrays.stream(rhs.split(",")).map(String::trim).collect(Collectors.toList()));
            return ls;
        }
        return null;
    }
}

