/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster.subcluster;

import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.rpc.RpcContext;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.rpc.config.TransportConfig;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.serialization.serializer.JsonSerializer;
import com.baidu.cloud.starlight.springcloud.client.cluster.Cluster;
import com.baidu.cloud.starlight.springcloud.client.cluster.ClusterSelector;
import com.baidu.cloud.starlight.springcloud.client.cluster.LoadBalancer;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.properties.OutlierConfig;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.common.SpringCloudConstants;
import com.baidu.cloud.thirdparty.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;

public class DefaultCluster
implements Cluster {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCluster.class);
    private ClusterSelector clusterSelector;
    private LoadBalancer loadBalancer;
    private volatile Map<Class<?>, ServiceConfig> serviceRefers;
    private StarlightClientProperties globalConfig;

    public DefaultCluster(ClusterSelector clusterSelector, StarlightClientProperties globalConfig, LoadBalancer loadBalancer) {
        this.clusterSelector = clusterSelector;
        this.serviceRefers = new ConcurrentHashMap();
        this.globalConfig = globalConfig;
        this.loadBalancer = loadBalancer;
    }

    @Override
    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    @Override
    public void setServiceRefers(Map<Class<?>, ServiceConfig> referServices) {
        this.serviceRefers = referServices;
    }

    @Override
    public ClusterSelector getClusterSelector() {
        return this.clusterSelector;
    }

    @Override
    public void execute(Request request, RpcCallback callback) {
        long starTime = System.currentTimeMillis();
        ServiceInstance instance = this.getLoadBalancer().choose(this.clusterSelector);
        LOGGER.debug("Select instance from ribbon cost: {}", (Object)(System.currentTimeMillis() - starTime));
        if (instance == null) {
            throw new StarlightRpcException(SpringCloudConstants.NO_INSTANCE_ERROR_CODE, "No instances available for service " + this.getClusterSelector().getServiceId() + ", cluster " + this.getClusterSelector().getClusterName());
        }
        SingleStarlightClient starlightClient = null;
        try {
            starlightClient = this.initSingleClient(instance.getHost(), instance.getPort());
        }
        catch (Exception e) {
            RpcContext.getContext().setRemoteAddress(instance.getHost(), instance.getPort());
            LOGGER.warn("AbstractClusterClient unexpect error ", (Throwable)e);
            callback.onError((Throwable)e);
            return;
        }
        ServiceConfig serviceConfig = request.getServiceConfig();
        if (serviceConfig == null) {
            throw new StarlightRpcException(StarlightRpcException.BAD_REQUEST, "The request service has not been refer, please call refer() before request, service {" + request.getServiceClass().getName() + "}");
        }
        String protocolName = this.requestProtocol(serviceConfig, instance);
        request.setProtocolName(protocolName);
        this.addStargateMetadata(request, serviceConfig, instance);
        try {
            this.getLoadBalancer().execute(this.clusterSelector, starlightClient, instance, request, callback);
        }
        catch (Throwable e) {
            RpcContext.getContext().setRemoteAddress(instance.getHost(), instance.getPort());
            callback.onError((Throwable)new StarlightRpcException(StarlightRpcException.INTERNAL_SERVER_ERROR, "Request failed: " + e.getMessage()));
        }
    }

    private String requestProtocol(ServiceConfig serviceConfig, ServiceInstance instance) {
        String protocolName = serviceConfig.getProtocol();
        if (StringUtils.isEmpty((String)protocolName)) {
            if (instance.getMetadata() == null || instance.getMetadata().size() == 0 || StringUtils.isEmpty((String)((String)instance.getMetadata().get("protocols")))) {
                LOGGER.warn("Unable to select protocol for request: there is nor protocol message in registration message or in configuration.Will use the default protocol brpc");
                protocolName = "brpc";
            } else {
                String protocols = (String)instance.getMetadata().get("protocols");
                protocolName = protocols.split(",")[0];
            }
        }
        return protocolName;
    }

    private void addStargateMetadata(Request request, ServiceConfig serviceConfig, ServiceInstance instance) {
        if (!request.getProtocolName().equals("stargate")) {
            return;
        }
        if (instance.getMetadata() == null || instance.getMetadata().size() <= 0) {
            return;
        }
        if (StringUtils.isEmpty((String)((String)instance.getMetadata().get("interfaces")))) {
            LOGGER.warn("Request service {} method {} protocol stargate. There is no interfaces message in registration message, will use default group[normal] and version[1.0.0]", (Object)request.getServiceName(), (Object)request.getMethodName());
            return;
        }
        String interfaceStr = (String)instance.getMetadata().get("interfaces");
        if (!interfaceStr.contains(request.getServiceClass().getName())) {
            LOGGER.warn("Request service {}, method {}, protocol stargate, interface metadata {}. The registration interfaces metadata dose not contain the service, will use default group[normal] and version[1.0.0]. ", new Object[]{request.getServiceClass().getName(), request.getMethodName(), interfaceStr});
            return;
        }
        try {
            List interfaces = (List)JsonSerializer.OBJECT_MAPPER.readValue(interfaceStr, (TypeReference)new TypeReference<List<String>>(){});
            if (interfaces == null || interfaces.size() == 0) {
                LOGGER.warn("Request service {}, method {}, protocol stargate, interface metadata {}. The result of parsing registration interfaces metadata is empty, will use default group[normal] and version[1.0.0]. ", new Object[]{request.getServiceClass().getName(), request.getMethodName(), interfaceStr});
                return;
            }
            for (String interfaceName : interfaces) {
                if (!interfaceName.contains(request.getServiceClass().getName())) continue;
                String[] metadata = interfaceName.split(":");
                if (metadata.length != 3) {
                    LOGGER.warn("Request service {}, method {}, protocol stargate, interface {}. The interface info parse from registration metadata is illegal, will use default group[normal] and version[1.0.0]. ", new Object[]{request.getServiceClass().getName(), request.getMethodName(), interfaceName});
                    return;
                }
                serviceConfig.setGroup(metadata[0]);
                serviceConfig.setVersion(metadata[2]);
                LOGGER.debug("Request service {}, method {} use protocol {}, group is {}, version is {}", new Object[]{request.getServiceName(), request.getMethodName(), request.getProtocolName(), serviceConfig.getGroup(), serviceConfig.getVersion()});
                return;
            }
            LOGGER.debug("Request service {}, method {}, protocol stargate, interfaces {}. The interface list parse from metadata do not contain the request service, will use default group[normal] and version[1.0.0]. ", new Object[]{request.getServiceClass().getName(), request.getMethodName(), interfaces});
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot use stargate to send request, parse interfaces metadata failed, interface metadata " + interfaceStr + " please check provider registration metadata");
        }
    }

    protected SingleStarlightClient initSingleClient(String host, Integer port) {
        TransportConfig transportConfig = this.globalConfig.transportConfig(this.clusterSelector.getServiceId());
        transportConfig.setAdditional(this.clientConfigMap());
        return SingleStarlightClientManager.getInstance().getOrCreateSingleClient(host, port, transportConfig, this.serviceRefers);
    }

    protected Map<String, String> clientConfigMap() {
        HashMap<String, String> configAdd = new HashMap<String, String>();
        OutlierConfig outlierConfig = this.globalConfig.getOutlierConfig(this.clusterSelector.getServiceId());
        if (outlierConfig != null) {
            configAdd.put("outlier_detect_enabled", String.valueOf(outlierConfig.getEnabled()));
            configAdd.put("outlier_detect_interval", String.valueOf(outlierConfig.getDetectInterval()));
            configAdd.put("outlier_detect_mini_request_num", String.valueOf(outlierConfig.getFailurePercentMinRequest()));
            configAdd.put("outlier_detect_fail_percent_threshold", String.valueOf(outlierConfig.getFailurePercentThreshold()));
            if (outlierConfig.getFailureCountThreshold() != null) {
                configAdd.put("outlier_detect_fail_count_threshold", String.valueOf(outlierConfig.getFailureCountThreshold()));
            }
        }
        return configAdd;
    }
}

