/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.outlier;

import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.filter.Filter;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.rpc.Invoker;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.statistics.CountStats;
import com.baidu.cloud.starlight.api.statistics.Stats;
import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.core.statistics.FixedTimeWindowStats;
import com.baidu.cloud.starlight.core.statistics.StarlightStatistics;
import com.baidu.cloud.starlight.core.statistics.StarlightStatsManager;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.outlier.OutlierDetectEvent;
import com.baidu.cloud.starlight.springcloud.common.SpringCloudConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlierDetectFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutlierDetectFilter.class);

    public void filterRequest(Invoker invoker, Request request, RpcCallback callback) {
        try {
            this.configureOutlier(request);
        }
        catch (Throwable e) {
            LOGGER.warn("OutlierDetectFilter filterRequest failed. ", e);
        }
        invoker.invoke(request, callback);
    }

    public void filterResponse(Response response, Request request) {
        try {
            SingleStarlightClientManager starlightClientManager = SingleStarlightClientManager.getInstance();
            URI remoteURI = request.getRemoteURI();
            if (remoteURI == null) {
                LOGGER.warn("OutlierFilter cannot find the statistics, because remote uri is null");
                return;
            }
            boolean outlierEnable = remoteURI.getParameter("outlier_detect_enabled", SpringCloudConstants.OUTLIER_DETECT_ENABLED.booleanValue());
            if (!outlierEnable) {
                return;
            }
            StarlightStatistics statistics = StarlightStatsManager.getStats((URI)remoteURI);
            if (statistics == null) {
                LOGGER.warn("OutlierFilter cannot find the statistics of {} from StarlightStatsManager", (Object)remoteURI.getAddress());
                return;
            }
            Stats stats = statistics.discoverStats("outlier_stats");
            if (!(stats instanceof CountStats)) {
                LOGGER.warn("OutlierFilter cannot find the fixed time window statistics of {}", (Object)remoteURI.getAddress());
                return;
            }
            CountStats outlierStats = (CountStats)stats;
            Integer outlierMinReqNum = remoteURI.getParameter("outlier_detect_mini_request_num", SpringCloudConstants.OUTLIER_DETECT_MINI_REQUEST_NUM.intValue());
            Integer totalReqCount = outlierStats.totalReqCount();
            Integer failReqCount = outlierStats.failReqCount();
            if (totalReqCount < outlierMinReqNum) {
                return;
            }
            String outlierDetectFailCount = remoteURI.getParameter("outlier_detect_fail_count_threshold");
            if (!StringUtils.isEmpty((String)outlierDetectFailCount)) {
                int outlierFailCount = Integer.parseInt(outlierDetectFailCount);
                if (failReqCount >= outlierFailCount) {
                    this.markOutlier(remoteURI, starlightClientManager, outlierStats);
                }
            } else {
                int outlierDetectFailPercent = remoteURI.getParameter("outlier_detect_fail_percent_threshold", SpringCloudConstants.OUTLIER_DETECT_FAIL_PERCENT_THRESHOLD.intValue());
                int failPercent = this.failPercent(failReqCount, totalReqCount);
                if (failPercent > outlierDetectFailPercent) {
                    this.markOutlier(remoteURI, starlightClientManager, outlierStats);
                }
            }
        }
        catch (Throwable throwable) {
            LOGGER.warn("OutlierDetectFilter filterResponse failed. ", throwable);
        }
    }

    private void markOutlier(URI remoteURI, SingleStarlightClientManager starlightClientManager, CountStats outlierStats) {
        SingleStarlightClient singleClient = starlightClientManager.getSingleClient(remoteURI.getHost(), remoteURI.getPort());
        if (singleClient == null) {
            LOGGER.warn("Statistics of {} is exist in StatisticsManager, but SingleStarlightClient associated with it is not exist in ClientManager", (Object)remoteURI.getAddress());
            return;
        }
        Integer detectFailCount = null;
        String outlierDetectFailCount = remoteURI.getParameter("outlier_detect_fail_count_threshold");
        if (!StringUtils.isEmpty((String)outlierDetectFailCount)) {
            detectFailCount = Integer.parseInt(outlierDetectFailCount);
        }
        int detectInterval = remoteURI.getParameter("outlier_detect_interval", SpringCloudConstants.OUTLIER_DETECT_INTERVAL.intValue());
        Integer detectFailPercent = null;
        String outlierDetectFailPct = remoteURI.getParameter("outlier_detect_fail_percent_threshold");
        if (!StringUtils.isEmpty((String)outlierDetectFailPct)) {
            detectFailPercent = Integer.parseInt(outlierDetectFailPct);
        }
        int failPercent = this.failPercent(outlierStats.failReqCount(), outlierStats.totalReqCount());
        OutlierDetectEvent detectEvent = new OutlierDetectEvent();
        detectEvent.setReqCount(outlierStats.totalReqCount());
        detectEvent.setSuccReqCount(outlierStats.sucReqCount());
        detectEvent.setFailCount(outlierStats.failReqCount());
        detectEvent.setDetectFailCount(detectFailCount);
        detectEvent.setDetectFailPercent(detectFailPercent);
        detectEvent.setFailPercent(failPercent);
        detectEvent.setDetectInterval(detectInterval);
        PeerStatus peerStatus = new PeerStatus(PeerStatus.Status.OUTLIER, Long.valueOf(System.currentTimeMillis()));
        peerStatus.setStatusReason((Object)detectEvent);
        singleClient.updateStatus(peerStatus);
    }

    private int failPercent(int failReqCount, int totalReqCount) {
        return (int)((double)failReqCount * 0.1 / ((double)totalReqCount * 0.1) * 100.0);
    }

    private void configureOutlier(Request request) {
        URI remoteURI = request.getRemoteURI();
        StarlightStatistics statistics = StarlightStatsManager.getOrCreateStats((URI)remoteURI);
        boolean outlierEnable = remoteURI.getParameter("outlier_detect_enabled", SpringCloudConstants.OUTLIER_DETECT_ENABLED.booleanValue());
        if (!outlierEnable) {
            return;
        }
        int detectInterval = remoteURI.getParameter("outlier_detect_interval", SpringCloudConstants.OUTLIER_DETECT_INTERVAL.intValue());
        if (statistics.discoverStats("outlier_stats") == null) {
            FixedTimeWindowStats outlierStats = new FixedTimeWindowStats((long)detectInterval);
            statistics.registerStats("outlier_stats", (Stats)outlierStats);
        }
    }
}

