/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.properties;

import com.baidu.cloud.thirdparty.apache.commons.lang3.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="starlight.client.route")
public class StarlightRouteProperties {
    static final String PREFIX = "starlight.client.route";
    private final Map<String, String> labelSelectorCache = new ConcurrentHashMap<String, String>();
    private Boolean enabled = true;
    private Boolean noInstanceFallBack = true;
    private Selector labelSelector = new Selector();

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Selector getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(Selector labelSelector) {
        this.labelSelector = labelSelector;
    }

    public Boolean getNoInstanceFallBack() {
        return this.noInstanceFallBack;
    }

    public void setNoInstanceFallBack(Boolean noInstanceFallBack) {
        this.noInstanceFallBack = noInstanceFallBack;
    }

    public String getServiceLabelSelector(String serviceId) {
        String selector = this.labelSelectorCache.computeIfAbsent(serviceId, k -> {
            String labelSelector = "";
            labelSelector = this.labelSelector.getEnableProviderSelector() == null || this.labelSelector.getEnableProviderSelector() == false ? this.labelSelector.globalSelector : this.mergeSelector(this.labelSelector.globalSelector, (String)this.labelSelector.providerSelector.get(serviceId));
            return labelSelector;
        });
        return selector;
    }

    public String mergeSelector(String globalSelector, String selector) {
        if (StringUtils.isBlank((CharSequence)selector)) {
            return globalSelector;
        }
        if (StringUtils.isBlank((CharSequence)globalSelector)) {
            return selector;
        }
        HashSet uniqueKeys = new HashSet();
        return Stream.of(selector, globalSelector).map(this::splitSelectorsByKey).flatMap(Collection::stream).map(x -> {
            if (!uniqueKeys.contains(x[0])) {
                uniqueKeys.add(x[0]);
                return x[1];
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(" && "));
    }

    private List<String[]> splitSelectorsByKey(String selector) {
        return Stream.of(selector.split("&&")).map(String::trim).filter(StringUtils::isNotBlank).map(x -> {
            for (String splitter : new String[]{" not in ", " in ", "!=", "="}) {
                int i = x.indexOf(splitter);
                if (i == -1) continue;
                return new String[]{x.substring(0, i).trim(), x};
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static class Selector {
        private Map<String, String> providerSelector;
        private String globalSelector;
        private Boolean enableProviderSelector;

        public Map<String, String> getProviderSelector() {
            return this.providerSelector;
        }

        public void setProviderSelector(Map<String, String> providerSelector) {
            this.providerSelector = providerSelector;
        }

        public String getGlobalSelector() {
            return this.globalSelector;
        }

        public void setGlobalSelector(String globalSelector) {
            this.globalSelector = globalSelector;
        }

        public Boolean getEnableProviderSelector() {
            return this.enableProviderSelector;
        }

        public void setEnableProviderSelector(boolean enableProviderSelector) {
            this.enableProviderSelector = enableProviderSelector;
        }
    }
}

