/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.ribbon;

import com.baidu.cloud.starlight.springcloud.client.cluster.AbstractClusterClient;
import com.netflix.loadbalancer.ILoadBalancer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.netflix.ribbon.RibbonEagerLoadProperties;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

public class RibbonNamedContextInitializer
implements ApplicationListener<ApplicationStartedEvent>,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(RibbonNamedContextInitializer.class);
    private static final String ALL_CLIENT_NAMES = "*";
    private ApplicationContext applicationContext;
    private RibbonEagerLoadProperties eagerLoadProperties;
    private SpringClientFactory clientFactory;

    public RibbonNamedContextInitializer(SpringClientFactory clientFactory, RibbonEagerLoadProperties properties) {
        this.clientFactory = clientFactory;
        this.eagerLoadProperties = properties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.autoInit();
    }

    public void autoInit() {
        block9: {
            if (this.eagerLoadProperties.getClients() == null) {
                return;
            }
            try {
                String clientName0 = (String)this.eagerLoadProperties.getClients().get(0);
                if (clientName0.trim().equalsIgnoreCase(ALL_CLIENT_NAMES)) {
                    try {
                        Map clusterClients = this.applicationContext.getBeansOfType(AbstractClusterClient.class);
                        if (clusterClients != null) {
                            for (AbstractClusterClient clusterClient : clusterClients.values()) {
                                this.clientFactory.getInstance(clusterClient.getName(), ILoadBalancer.class);
                            }
                        }
                        break block9;
                    }
                    catch (BeansException e) {
                        LOGGER.warn("Get AbstractClusterClient from applicationContext failed, caused by ", (Throwable)e);
                        break block9;
                    }
                }
                for (String clientName : this.eagerLoadProperties.getClients()) {
                    this.clientFactory.getInstance(clientName, ILoadBalancer.class);
                }
            }
            catch (Throwable e) {
                LOGGER.warn("Auto initialize ribbon contexts failed, caused by ", e);
            }
        }
    }

    public void manualInit(String clientName) {
        if (this.clientFactory == null) {
            LOGGER.warn("SpringClientFactory is null when manual call init, plz make sure the bean is injection");
        }
        try {
            LOGGER.debug("Manual initialize ribbon context {} initializing", (Object)clientName);
            this.clientFactory.getInstance(clientName, ILoadBalancer.class);
            LOGGER.debug("Manual initialize ribbon context {} initialized", (Object)clientName);
        }
        catch (Throwable e) {
            LOGGER.warn("Manual initialize ribbon context " + clientName + " failed, caused by ", e);
        }
    }
}

