/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.ribbon;

import com.baidu.cloud.starlight.api.rpc.threadpool.NamedThreadFactory;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.netflix.loadbalancer.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RibbonServerLocalStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RibbonServerLocalStore.class);
    private static final Integer STORE_LOCAL_CACHE_DELAY = 180000;
    private final String clientName;
    private final StarlightClientProperties starlightProperties;
    private Properties localSrvListCache;
    private File cacheFile;
    private static final Gson GSON = new Gson();
    private ScheduledExecutorService storeCacheExecutor;

    public RibbonServerLocalStore(String clientName, StarlightClientProperties clientProperties) {
        this.clientName = clientName;
        this.starlightProperties = clientProperties;
        this.initLocalCache();
    }

    public void initLocalCache() {
        if (this.starlightProperties.getLocalCacheEnabled(this.clientName).booleanValue()) {
            this.localSrvListCache = new Properties();
            String cacheFilePath = this.getCacheFileName();
            this.createCacheFile(cacheFilePath);
            this.loadCachedListOfServers();
            this.storeCacheExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("StoreLocal-" + this.clientName));
            this.storeCacheExecutor.scheduleWithFixedDelay(this::storeCachedListOfServer, STORE_LOCAL_CACHE_DELAY.intValue(), STORE_LOCAL_CACHE_DELAY.intValue(), TimeUnit.MILLISECONDS);
        }
    }

    public void loadCachedListOfServers() {
        if (this.cacheFile != null && this.cacheFile.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.cacheFile);
                this.localSrvListCache.load(in);
                LOGGER.info("Load server list of " + this.clientName + " from local disk success");
            }
            catch (Throwable e) {
                LOGGER.warn("Load server list of " + this.clientName + " from local disk failed. ", e);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Close cache file input stream failed. ", (Throwable)e);
                    }
                }
            }
        }
    }

    public List<Server> getCachedListOfServers() {
        long getCost;
        ArrayList<Server> cachedServerList = new ArrayList<Server>();
        Set<Map.Entry<Object, Object>> cacheEntries = this.localSrvListCache.entrySet();
        if (cacheEntries.size() == 0) {
            LOGGER.info("Local cache dose not have any server when get server list from it.");
            return cachedServerList;
        }
        long getStartTime = System.currentTimeMillis();
        for (Map.Entry<Object, Object> entry : cacheEntries) {
            String serversClassName = (String)entry.getKey();
            String serverListJson = (String)entry.getValue();
            if (StringUtils.isEmpty((Object)serversClassName) || StringUtils.isEmpty((Object)serverListJson)) continue;
            try {
                List<?> cachedList = this.jsonToServerList(serverListJson, Class.forName(serversClassName));
                cachedServerList.addAll(cachedList);
                LOGGER.info("Get server list from local cache success, size {}", (Object)cachedServerList.size());
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Get server list from local cache failed. ", (Throwable)e);
            }
            break;
        }
        if ((getCost = System.currentTimeMillis() - getStartTime) > 2000L) {
            LOGGER.info("Get cache list cost {}ms", (Object)getCost);
        }
        LOGGER.debug("Get cache list cost {}ms", (Object)getCost);
        return cachedServerList;
    }

    private <T> List<T> jsonToServerList(String json, Class<T> serverClass) {
        Type type = new TypeToken<ArrayList<JsonObject>>(){}.getType();
        ArrayList jsonObjs = (ArrayList)GSON.fromJson(json, type);
        ArrayList<Object> serverList = new ArrayList<Object>();
        for (JsonObject jsonObj : jsonObjs) {
            serverList.add(GSON.fromJson((JsonElement)jsonObj, serverClass));
        }
        return serverList;
    }

    public void updateCachedListOfServers(List<Server> servers) {
        if (servers == null || servers.size() == 0) {
            return;
        }
        long updateStartTime = System.currentTimeMillis();
        String serversClassName = servers.get(0).getClass().getName();
        String serverListJson = GSON.toJson(servers);
        this.localSrvListCache.setProperty(serversClassName, serverListJson);
        long updateCost = System.currentTimeMillis() - updateStartTime;
        if (updateCost > 2000L) {
            LOGGER.info("Update CachedListOfServers cost {}ms", (Object)updateCost);
        }
        LOGGER.debug("Update CachedListOfServers cost {}ms", (Object)updateCost);
    }

    public synchronized void storeCachedListOfServer() {
        if (this.cacheFile == null || !this.cacheFile.exists()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try (FileOutputStream out = new FileOutputStream(this.cacheFile);){
            this.localSrvListCache.store(out, "Starlight Local Registry");
        }
        catch (Throwable e) {
            LOGGER.warn("Store server list to local disk cache failed. ", e);
        }
        long storeCost = System.currentTimeMillis() - startTime;
        if (storeCost > 2000L) {
            LOGGER.info("Store CachedListOfServers cost {}ms", (Object)storeCost);
        }
        LOGGER.debug("Store CachedListOfServers cost {}ms", (Object)storeCost);
    }

    public void close() {
        if (this.storeCacheExecutor != null) {
            this.storeCacheExecutor.shutdown();
        }
        this.storeCachedListOfServer();
    }

    private String getCacheFileName() {
        return System.getProperty("java.io.tmpdir") + "/starlight/local-registry/" + this.clientName + ".cache";
    }

    protected void createCacheFile(String cacheFilePath) {
        this.cacheFile = new File(cacheFilePath);
        if (!this.cacheFile.getParentFile().exists()) {
            if (!this.cacheFile.getParentFile().mkdirs()) {
                LOGGER.warn("Invalid file cache path " + cacheFilePath + ", failed to create dirs " + this.cacheFile.getParentFile());
            } else {
                try {
                    if (!this.cacheFile.exists()) {
                        this.cacheFile.createNewFile();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Create new cache file failed when init local cache, cause by: {}", (Object)e.getMessage());
                }
            }
        } else {
            try {
                if (!this.cacheFile.exists()) {
                    this.cacheFile.createNewFile();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Create new cache file failed when init local cache, cause by: {}", (Object)e.getMessage());
            }
        }
    }
}

