/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.ribbon;

import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.client.ribbon.RibbonServerLocalStore;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightAwareDynamicLoadBalancer;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightRibbonServer;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightServerListFilter;
import com.baidu.cloud.thirdparty.netty.util.Timeout;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ServerListUpdater;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarlightActiveLoadBalancer<T extends Server>
extends StarlightAwareDynamicLoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarlightActiveLoadBalancer.class);
    private static final Integer CLEAN_UP_TASK_INIT_DELAY_SECOND = 1800;
    private static final Integer OFFLINE_CLIENT_CLEAN_UP_PERIOD = 3600;
    private RibbonServerLocalStore localStore;
    private final SingleStarlightClientManager clientManager;
    private final ScheduledFuture<?> scheduledFuture;
    private static final Map<Class, Method> METADATA_METHODS = new HashMap<Class, Method>();
    private List<StarlightServerListFilter> serverListFilters;

    public StarlightActiveLoadBalancer(SingleStarlightClientManager clientManager, IClientConfig config, IRule rule, IPing ping, ServerList serverList, ServerListFilter serverListFilter, ServerListUpdater serverListUpdater, StarlightClientProperties clientProperties) {
        super(config, rule, ping, serverList, serverListFilter, serverListUpdater, clientProperties);
        this.clientManager = clientManager;
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledFuture = executorService.scheduleAtFixedRate(new ClientCleanUpTask(), CLEAN_UP_TASK_INIT_DELAY_SECOND.intValue(), OFFLINE_CLIENT_CLEAN_UP_PERIOD.intValue(), TimeUnit.SECONDS);
    }

    public List<Server> getReachableServers() {
        return this.activeServers(super.getReachableServers());
    }

    public List<Server> getAllServers() {
        return this.activeServers(super.getAllServers());
    }

    @Override
    void restOfInit(IClientConfig clientConfig) {
        if (this.getClientProperties().getLocalCacheEnabled(this.getName()).booleanValue()) {
            this.localStore = new RibbonServerLocalStore(clientConfig.getClientName(), this.getClientProperties());
        }
        super.restOfInit(clientConfig);
    }

    @Override
    public void setServersList(List lsrv) {
        List serverList = lsrv;
        long startTime = System.currentTimeMillis();
        List<StarlightRibbonServer> starlightServers = this.convertToStarlightServer(serverList);
        long cost = System.currentTimeMillis() - startTime;
        if (cost > 5L) {
            LOGGER.warn("convertToStarlightServer cost > 5, size {}, cost {}", (Object)serverList.size(), (Object)cost);
        }
        super.setServersList(starlightServers);
    }

    public void setStarlightServerListFilters(List<StarlightServerListFilter> serverListFilters) {
        this.serverListFilters = serverListFilters;
    }

    public void destroy() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(true);
        }
        if (this.localStore != null) {
            this.localStore.close();
            this.localStore = null;
        }
        for (StarlightServerListFilter serverListFilter : this.serverListFilters) {
            serverListFilter.destroy();
        }
    }

    protected List<Server> activeServers(List<Server> originServers) {
        if ((originServers = this.updateOrGetCacheServers(originServers)) == null || originServers.size() < 1) {
            return originServers;
        }
        if (this.serverListFilters == null || this.serverListFilters.size() < 1) {
            return originServers;
        }
        List<Server> serverList = new LinkedList<Server>(originServers);
        for (StarlightServerListFilter serverListFilter : this.serverListFilters) {
            serverList = serverListFilter.getFilteredList(serverList);
        }
        return serverList;
    }

    private List<Server> updateOrGetCacheServers(List<Server> originServers) {
        if (!this.getClientProperties().getLocalCacheEnabled(this.getName()).booleanValue() || this.localStore == null) {
            return originServers;
        }
        try {
            if (originServers == null || originServers.size() == 0) {
                return this.localStore.getCachedListOfServers();
            }
            this.localStore.updateCachedListOfServers(originServers);
            return originServers;
        }
        catch (Throwable e) {
            LOGGER.warn("Update or get cached servers failed, caused by ", e);
            return originServers;
        }
    }

    private List<StarlightRibbonServer> convertToStarlightServer(List<Server> originServers) {
        return originServers.stream().map(server -> {
            StarlightRibbonServer starlightRibbonServer = new StarlightRibbonServer(server.getHost(), server.getPort());
            starlightRibbonServer.setAlive(true);
            starlightRibbonServer.setMetadata(new HashMap<String, String>());
            Class<?> clazz = server.getClass();
            Method metadataMethod = METADATA_METHODS.computeIfAbsent(clazz, aClass -> {
                Method method = null;
                try {
                    method = clazz.getDeclaredMethod("getMetadata", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warn("Convert to StarlightRibbonServer failed, cause by NoSuchMethod");
                }
                return method;
            });
            if (metadataMethod != null) {
                Map metadata = null;
                try {
                    metadata = (Map)metadataMethod.invoke(server, new Object[0]);
                    starlightRibbonServer.setMetadata(metadata);
                }
                catch (Exception e) {
                    LOGGER.warn("Convert to StarlightRibbonServer failed, cause by reflect call failed");
                }
            }
            return starlightRibbonServer;
        }).collect(Collectors.toList());
    }

    private class ClientCleanUpTask
    implements Runnable {
        private ClientCleanUpTask() {
        }

        @Override
        public void run() {
            for (Map.Entry<String, SingleStarlightClient> entry : StarlightActiveLoadBalancer.this.clientManager.allSingleClients().entrySet()) {
                long inactiveDuration;
                if (entry.getValue().isActive() || (inactiveDuration = System.currentTimeMillis() - entry.getValue().getStatus().getStatusRecordTime()) < (long)(OFFLINE_CLIENT_CLEAN_UP_PERIOD * 1000)) continue;
                String clientId = entry.getKey();
                String[] ipPort = clientId.split(":");
                LOGGER.info("StarlightActiveLoadBalancer detects that remote {} has not been used for 2h, will remove from ClientManager", (Object)clientId);
                StarlightActiveLoadBalancer.this.clientManager.removeSingleClient(ipPort[0], Integer.valueOf(ipPort[1]));
                for (StarlightServerListFilter filter : StarlightActiveLoadBalancer.this.serverListFilters) {
                    Timeout timeout;
                    if (filter.getServerListFilterTasks() == null || !((timeout = filter.getServerListFilterTasks().get(clientId)) instanceof Timeout)) continue;
                    LOGGER.info("StarlightActiveLoadBalancer detects that remote {} has not been used for 2h, will cancel the tasks", (Object)clientId);
                    timeout.cancel();
                }
            }
        }
    }
}

