/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.ribbon.lalb;

import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.statistics.Stats;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LalbLatencyStats
implements Stats {
    public static final Integer DEFAULT_WINDOW_SIZE = 10;
    private final Queue<Long> latencyWindow = new ConcurrentLinkedQueue<Long>();

    public Queue<Long> getLatencyWindow() {
        return this.latencyWindow;
    }

    public void updateLatencyWindow(Long latency) {
        Queue<Long> latencyWindow = this.getLatencyWindow();
        latencyWindow.add(latency);
        if (latencyWindow.size() > DEFAULT_WINDOW_SIZE) {
            latencyWindow.poll();
        }
    }

    public Long avgLatency() {
        return this.avgLatency(this.latencyWindow.size());
    }

    protected Long avgLatency(int windowSize) {
        if (windowSize == 0) {
            return 0L;
        }
        Long latencies = 0L;
        for (Long latency : this.latencyWindow) {
            latencies = latencies + latency;
        }
        return latencies / (long)windowSize;
    }

    public void record(Request request, Response response) {
        Long latency = this.latency(request, response);
        if (latency != null) {
            this.updateLatencyWindow(latency);
        }
    }

    private Long latency(Request request, Response response) {
        Object latency = request.getNoneAdditionKv().get("client_request_cost");
        if (latency instanceof Long) {
            return (Long)latency;
        }
        return null;
    }
}

