/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.ribbon.lalb;

import com.baidu.cloud.starlight.api.statistics.Stats;
import com.baidu.cloud.starlight.core.statistics.StarlightStatistics;
import com.baidu.cloud.starlight.core.statistics.StarlightStatsManager;
import com.baidu.cloud.starlight.springcloud.client.ribbon.lalb.LalbLatencyStats;
import com.baidu.cloud.starlight.springcloud.client.ribbon.lalb.WeightTreeNode;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.RandomRule;
import com.netflix.loadbalancer.Server;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalityAwareRule
extends RandomRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalityAwareRule.class);
    public static final String LALB_STATS_KEY = "lalb_latency_stats";
    private static final long DEFAULT_WEIGHT = 30L;
    private static final int MIN_INSTANCE_NUM = 3;
    private static final float ACTIVE_INSTANCE_RATIO = 0.7f;
    private static final int MIN_LATENCY_WINDOW = 3;
    private WeightTreeNode<Server> weightTree;
    private AtomicLong maxWeight = new AtomicLong(0L);

    public LocalityAwareRule() {
        this.weightTree = new WeightTreeNode();
    }

    public void setLoadBalancer(ILoadBalancer lb) {
        super.setLoadBalancer(lb);
    }

    public Server choose(Object key) {
        this.updateWeightTree();
        if (this.weightTree.getWeight() == 0L) {
            Server result = super.choose(key);
            this.addLalbLatencyStats(result);
            return result;
        }
        long totalWeight = this.weightTree.getWeight();
        long randomWeight = ThreadLocalRandom.current().nextLong(totalWeight);
        WeightTreeNode<Server> choseNode = this.searchNode(this.weightTree, randomWeight);
        Server result = choseNode.getNodeEntity();
        this.addLalbLatencyStats(result);
        return result;
    }

    protected <T> WeightTreeNode<T> searchNode(WeightTreeNode<T> weightTree, long weight) {
        if (weightTree.getLeftNode() == null) {
            return weightTree;
        }
        if (weightTree.getRightNode() == null) {
            return weightTree.getLeftNode();
        }
        if (weightTree.getLeftNode().getWeight() >= weight) {
            return this.searchNode(weightTree.getLeftNode(), weight);
        }
        return this.searchNode(weightTree.getRightNode(), weight - weightTree.getLeftNode().getWeight());
    }

    protected synchronized void updateWeightTree() {
        try {
            List servers = this.getLoadBalancer().getAllServers();
            this.weightTree = servers != null && servers.size() > 0 ? this.generateWeightTreeByNodes(this.weightTreeNodes(servers)) : new WeightTreeNode();
        }
        catch (Exception e) {
            LOGGER.error("Update ServiceInstance weight tree error", (Throwable)e);
        }
    }

    protected Queue<WeightTreeNode<Server>> weightTreeNodes(List<Server> serviceInstances) {
        LinkedList<WeightTreeNode<Server>> weightTreeNodes = new LinkedList<WeightTreeNode<Server>>();
        long startTime = System.currentTimeMillis();
        if (serviceInstances != null) {
            HashMap<LalbLatencyStats, Server> lalbLatencyStatsMap = new HashMap<LalbLatencyStats, Server>();
            LinkedList<Long> avgLatencies = new LinkedList<Long>();
            for (Server serviceInstance : serviceInstances) {
                Queue<Long> latencyWindow;
                StarlightStatistics statistics = StarlightStatsManager.getOrCreateStatsByHostPort((String)serviceInstance.getHostPort());
                Stats stats = statistics.discoverStats(LALB_STATS_KEY);
                if (!(stats instanceof LalbLatencyStats)) {
                    stats = new LalbLatencyStats();
                    statistics.registerStats(LALB_STATS_KEY, stats);
                }
                if ((latencyWindow = ((LalbLatencyStats)stats).getLatencyWindow()).size() >= 3) {
                    lalbLatencyStatsMap.put((LalbLatencyStats)stats, serviceInstance);
                    avgLatencies.add(((LalbLatencyStats)stats).avgLatency());
                    continue;
                }
                weightTreeNodes.add(new WeightTreeNode<Server>(this.serviceInstanceHashCode(serviceInstance), 30L, serviceInstance));
            }
            LOGGER.debug("LocalityAwareRule weightTreeNodes#lalbLatencyStatsMap cost {}ms", (Object)(System.currentTimeMillis() - startTime));
            if (lalbLatencyStatsMap.size() < 3 || (double)lalbLatencyStatsMap.size() * 1.0 / (double)serviceInstances.size() < (double)0.7f) {
                Long execCost = System.currentTimeMillis() - startTime;
                LOGGER.debug("LocalityAwareRule weightTreeNodes cost {}ms", (Object)execCost);
                if (execCost > 20L) {
                    LOGGER.warn("LocalityAwareRule weightTreeNodes cost {}ms", (Object)execCost);
                }
                return weightTreeNodes;
            }
            Long predictedMaxLatency = this.latency90Percentile(avgLatencies);
            for (Map.Entry entry : lalbLatencyStatsMap.entrySet()) {
                long weight = this.serviceInstanceWeight((LalbLatencyStats)entry.getKey(), predictedMaxLatency);
                weightTreeNodes.add(new WeightTreeNode(this.serviceInstanceHashCode((Server)entry.getValue()), weight, entry.getValue()));
            }
        }
        Long execCost = System.currentTimeMillis() - startTime;
        LOGGER.debug("LocalityAwareRule weightTreeNodes cost {}ms", (Object)execCost);
        if (execCost > 20L) {
            LOGGER.warn("LocalityAwareRule weightTreeNodes cost {}ms", (Object)execCost);
        }
        return weightTreeNodes;
    }

    protected Long latency90Percentile(List<Long> avgLatencies) {
        int percentileIndex = new Double((double)avgLatencies.size() * 0.9).intValue() - 1;
        if (percentileIndex < 0) {
            percentileIndex = 0;
        }
        Collections.sort(avgLatencies);
        return avgLatencies.get(percentileIndex);
    }

    protected long serviceInstanceWeight(LalbLatencyStats stats, Long predictedMaxLatency) {
        Long fixedWindowAvgLatency = stats.avgLatency();
        Long normalizedAvgLatency = fixedWindowAvgLatency * 100L / (predictedMaxLatency + 10L);
        long serviceInstanceWeight = 100L - normalizedAvgLatency;
        long weight = 0L;
        if (serviceInstanceWeight > 0L) {
            weight = serviceInstanceWeight > this.maxWeight.get() / 10L ? serviceInstanceWeight : this.maxWeight.get() / 10L + serviceInstanceWeight;
        } else {
            long l = weight = this.maxWeight.get() > 0L ? this.maxWeight.get() / 10L : 1L;
        }
        if (weight > this.maxWeight.get()) {
            this.maxWeight.getAndSet(weight);
        }
        return weight;
    }

    protected int serviceInstanceHashCode(Server serviceInstance) {
        return Objects.hash(serviceInstance);
    }

    protected <T> WeightTreeNode<T> generateWeightTreeByNodes(Queue<WeightTreeNode<T>> weightTreeNodes) {
        long cost;
        if (weightTreeNodes == null || weightTreeNodes.size() == 0) {
            return new WeightTreeNode();
        }
        long nodeSize = weightTreeNodes.size();
        if (nodeSize == 1L) {
            return weightTreeNodes.poll();
        }
        long startTime = System.currentTimeMillis();
        if (nodeSize % 2L != 0L) {
            weightTreeNodes.add(new WeightTreeNode());
        }
        WeightTreeNode rootNode = new WeightTreeNode();
        while (weightTreeNodes.size() > 0) {
            WeightTreeNode leftChildNode = weightTreeNodes.poll();
            WeightTreeNode rightChildNode = weightTreeNodes.poll();
            if (leftChildNode == null) {
                LOGGER.warn("Left node is null, break");
                break;
            }
            if (rightChildNode == null) {
                rootNode = leftChildNode;
                break;
            }
            WeightTreeNode parentNode = new WeightTreeNode(0, 0L);
            parentNode.setLeftNode(leftChildNode);
            leftChildNode.setParentNode(parentNode);
            parentNode.setRightNode(rightChildNode);
            rightChildNode.setParentNode(parentNode);
            parentNode.setWeight(leftChildNode.getWeight() + rightChildNode.getWeight());
            parentNode.setChildSize(2L + leftChildNode.getChildSize() + rightChildNode.getChildSize());
            weightTreeNodes.add(parentNode);
        }
        if ((cost = System.currentTimeMillis() - startTime) > 20L) {
            LOGGER.warn("LocalityAwareRule generateWeightTreeByNodes cost {}ms", (Object)cost);
        }
        LOGGER.debug("LocalityAwareRule generateWeightTreeByNodes cost {}ms", (Object)cost);
        return rootNode;
    }

    private void addLalbLatencyStats(Server server) {
        StarlightStatistics statistics = StarlightStatsManager.getOrCreateStatsByHostPort((String)server.getHostPort());
        statistics.registerStats(LALB_STATS_KEY, (Stats)new LalbLatencyStats());
    }

    protected WeightTreeNode<Server> getWeightTree() {
        return this.weightTree;
    }
}

