/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.shutdown;

import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.core.statistics.StarlightStatsManager;
import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightRibbonServer;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightServerListFilter;
import com.baidu.cloud.starlight.springcloud.common.SpringCloudConstants;
import com.baidu.cloud.thirdparty.netty.util.Timeout;
import com.baidu.cloud.thirdparty.netty.util.TimerTask;
import com.netflix.loadbalancer.Server;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ShutdownServerListFilter
implements StarlightServerListFilter<Server> {
    private static final Integer SHUTDOWN_CLEAN_UP_PERIOD = 1800000;
    private final SingleStarlightClientManager clientManager;
    private final StarlightClientProperties clientProperties;
    private final Map<String, Timeout> shutdownCleanTasks;

    public ShutdownServerListFilter(SingleStarlightClientManager clientManager, StarlightClientProperties clientProperties) {
        this.clientManager = clientManager;
        this.clientProperties = clientProperties;
        this.shutdownCleanTasks = new ConcurrentHashMap<String, Timeout>();
    }

    @Override
    public List<Server> getFilteredList(List<Server> originServers) {
        long filterStartTime = System.currentTimeMillis();
        if (originServers == null || originServers.size() <= 1) {
            return originServers;
        }
        LinkedList<Server> serverList = new LinkedList<Server>(originServers);
        for (Server server : originServers) {
            long shutdownTime;
            SingleStarlightClient starlightClient;
            Map<String, String> serverMetas;
            if (!(server instanceof StarlightRibbonServer) || (serverMetas = ((StarlightRibbonServer)server).getMetadata()) == null || serverMetas.size() <= 0 || (starlightClient = this.clientManager.getSingleClient(server.getHost(), server.getPort())) == null) continue;
            String epoch = serverMetas.get("EPOCH");
            if (StringUtils.isEmpty((String)epoch)) {
                LOGGER.debug("The server discovered by registry does not have EPOCH meta!");
                continue;
            }
            long epochTime = Long.parseLong(epoch);
            PeerStatus peerStatus = starlightClient.getStatus();
            if (peerStatus == null || !PeerStatus.Status.SHUTTING_DOWN.equals((Object)peerStatus.getStatus()) && !PeerStatus.Status.SHUTDOWN.equals((Object)peerStatus.getStatus()) || epochTime >= (shutdownTime = peerStatus.getStatusRecordTime().longValue())) continue;
            serverList.remove(server);
            LOGGER.info("Remote server {} had been removed because of shutdown, shutdownTime {}.", (Object)server.getHostPort(), (Object)peerStatus.getStatusRecordTime());
            this.submitTimerTask(server, SHUTDOWN_CLEAN_UP_PERIOD);
        }
        LOGGER.debug("ShutdownServerListFilter getFilteredList cost {}", (Object)(System.currentTimeMillis() - filterStartTime));
        return serverList;
    }

    @Override
    public Map<String, Timeout> getServerListFilterTasks() {
        return this.shutdownCleanTasks;
    }

    @Override
    public SingleStarlightClientManager getSingleClientManager() {
        return this.clientManager;
    }

    public int getOrder() {
        return SpringCloudConstants.SHUTTING_DOWN_SERVER_LIST_FILTER_ORDER;
    }

    @Override
    public void submitTimerTask(Server server, Integer execDelay) {
        if (this.shutdownCleanTasks.get(server.getHostPort()) != null) {
            return;
        }
        Timeout timeout = SERVER_LIST_FILTER_TIMER.newTimeout((TimerTask)new ShutdownInstanceCleanTask(server), (long)execDelay.intValue(), TimeUnit.SECONDS);
        this.shutdownCleanTasks.put(server.getHostPort(), timeout);
    }

    @Override
    public void destroy() {
        if (this.shutdownCleanTasks.size() > 0) {
            for (Map.Entry<String, Timeout> task : this.shutdownCleanTasks.entrySet()) {
                if (task == null || task.getValue() == null) continue;
                task.getValue().cancel();
            }
        }
    }

    private class ShutdownInstanceCleanTask
    implements TimerTask {
        private final Server server;

        public ShutdownInstanceCleanTask(Server server) {
            this.server = server;
        }

        public void run(Timeout timeout) throws Exception {
            SingleStarlightClient singleClient = ShutdownServerListFilter.this.clientManager.getSingleClient(this.server.getHost(), this.server.getPort());
            if (singleClient == null) {
                return;
            }
            PeerStatus peerStatus = singleClient.getStatus();
            if (peerStatus == null) {
                return;
            }
            if (!PeerStatus.Status.SHUTTING_DOWN.equals((Object)peerStatus.getStatus()) || !PeerStatus.Status.SHUTDOWN.equals((Object)peerStatus.getStatus())) {
                return;
            }
            if (System.currentTimeMillis() - peerStatus.getStatusRecordTime() >= (long)SHUTDOWN_CLEAN_UP_PERIOD.intValue()) {
                StarlightStatsManager.removeStats((URI)singleClient.remoteURI());
                ShutdownServerListFilter.this.clientManager.removeSingleClient(this.server.getHost(), this.server.getPort());
            }
        }
    }
}

