/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.server.properties;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.rpc.config.TransportConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="starlight.server")
public class StarlightServerProperties {
    static final String PREFIX = "starlight.server";
    private String name;
    private Integer port;
    private String host;
    private boolean enable;
    private String protocols = "brpc,stargate,springrest";
    private String compressType = "none";
    private String filters;
    private Integer allIdleTimeout = 210;
    private Integer ioThreadNum = Constants.DEFAULT_IO_THREADS_VALUE;
    private Integer acceptThreadNum = Constants.DEFAULT_ACCEPTOR_THREAD_VALUE;
    private Integer writeTimeoutMills = Constants.WRITE_TIMEOUT_VALUE;
    private GracefullyShutdown shutdown = new GracefullyShutdown();
    private Boolean connectKeepAliveEnable;
    private Integer registerDelay;
    private Integer bizThreadNum;
    private Integer ioRatio;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public String getCompressType() {
        return this.compressType;
    }

    public void setCompressType(String compressType) {
        this.compressType = compressType;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public Integer getAllIdleTimeout() {
        return this.allIdleTimeout;
    }

    public void setAllIdleTimeout(Integer allIdleTimeout) {
        this.allIdleTimeout = allIdleTimeout;
    }

    public Integer getIoThreadNum() {
        return this.ioThreadNum;
    }

    public void setIoThreadNum(Integer ioThreadNum) {
        this.ioThreadNum = ioThreadNum;
    }

    public Integer getAcceptThreadNum() {
        return this.acceptThreadNum;
    }

    public void setAcceptThreadNum(Integer acceptThreadNum) {
        this.acceptThreadNum = acceptThreadNum;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getWriteTimeoutMills() {
        return this.writeTimeoutMills;
    }

    public void setWriteTimeoutMills(Integer writeTimeoutMills) {
        this.writeTimeoutMills = writeTimeoutMills;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public GracefullyShutdown getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(GracefullyShutdown shutdown) {
        this.shutdown = shutdown;
    }

    public Boolean getConnectKeepAliveEnable() {
        return this.connectKeepAliveEnable;
    }

    public void setConnectKeepAliveEnable(Boolean connectKeepAliveEnable) {
        this.connectKeepAliveEnable = connectKeepAliveEnable;
    }

    public Integer getRegisterDelay() {
        return this.registerDelay;
    }

    public void setRegisterDelay(Integer registerDelay) {
        this.registerDelay = registerDelay;
    }

    public Integer getBizThreadNum() {
        return this.bizThreadNum;
    }

    public void setBizThreadNum(Integer bizThreadNum) {
        this.bizThreadNum = bizThreadNum;
    }

    public Integer getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(Integer ioRatio) {
        this.ioRatio = ioRatio;
    }

    public TransportConfig transportConfig() {
        TransportConfig transportConfig = new TransportConfig();
        transportConfig.setAcceptThreadNum(this.acceptThreadNum);
        transportConfig.setIoThreadNum(this.ioThreadNum);
        transportConfig.setAllIdleTimeout(this.allIdleTimeout);
        transportConfig.setWriteTimeoutMills(this.writeTimeoutMills);
        transportConfig.setGracefullyShutdown(Boolean.valueOf(this.shutdown.getGracefully()));
        transportConfig.setGracefullyQuietPeriod(this.shutdown.getQuietPeriod());
        transportConfig.setGracefullyTimeout(this.shutdown.getTimeout());
        transportConfig.setConnectKeepAliveEnable(this.connectKeepAliveEnable);
        transportConfig.setBizWorkThreadNum(this.bizThreadNum);
        transportConfig.setIoRatio(this.ioRatio);
        return transportConfig;
    }

    public class GracefullyShutdown {
        private boolean gracefully = true;
        private Integer quietPeriod = 2;
        private Integer timeout = 30;

        public boolean getGracefully() {
            return this.gracefully;
        }

        public void setGracefully(boolean gracefully) {
            this.gracefully = gracefully;
        }

        public Integer getQuietPeriod() {
            return this.quietPeriod;
        }

        public void setQuietPeriod(Integer quietPeriod) {
            this.quietPeriod = quietPeriod;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }
    }
}

