/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.server.register;

import com.baidu.cloud.starlight.api.rpc.StarlightServer;
import com.baidu.cloud.starlight.springcloud.server.register.StarlightRegisterListener;
import com.baidu.cloud.starlight.springcloud.server.register.consul.StarlightConsulRegisterListener;
import com.baidu.cloud.starlight.springcloud.server.register.gravity.StarlightGravityRegisterListener;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(name={"com.baidu.cloud.starlight.springcloud.server.StarlightServerAutoConfiguration", "org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistryAutoConfiguration", "com.baidu.formula.discovery.serviceregistry.FormulaServiceRegistryAutoConfiguration", "com.baidu.cloud.gravity.discovery.registry.GravityAutoServiceRegistrationAutoConfiguration"})
@ConditionalOnClass(name={"org.springframework.cloud.client.discovery.DiscoveryClient"})
@ConditionalOnProperty(name={"spring.cloud.discovery.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={StarlightServer.class})
public class StarlightRegisterAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={ConsulServiceRegistryAutoConfiguration.class})
    protected static class StarlightConsulRegisterAutoConfiguration {
        protected StarlightConsulRegisterAutoConfiguration() {
        }

        @Bean(destroyMethod="destroy")
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={ConsulServiceRegistryAutoConfiguration.class})
        public StarlightRegisterListener consulRegisterListener() {
            return new StarlightConsulRegisterListener();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"com.baidu.cloud.gravity.discovery.registry.GravityAutoServiceRegistrationAutoConfiguration"})
    protected static class StarlightGravityRegisterAutoConfiguration {
        protected StarlightGravityRegisterAutoConfiguration() {
        }

        @Bean(destroyMethod="destroy")
        @ConditionalOnMissingBean
        @ConditionalOnBean(type={"com.baidu.cloud.gravity.discovery.registry.GravityAutoServiceRegistrationAutoConfiguration"})
        public StarlightGravityRegisterListener starlightGravityRegisterListener() {
            return new StarlightGravityRegisterListener();
        }
    }
}

