/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.server.register;

import com.baidu.cloud.starlight.api.heartbeat.HeartbeatService;
import com.baidu.cloud.starlight.api.rpc.ServiceInvoker;
import com.baidu.cloud.starlight.api.rpc.threadpool.NamedThreadFactory;
import com.baidu.cloud.starlight.api.utils.NetUriUtils;
import com.baidu.cloud.starlight.core.rpc.RpcServiceRegistry;
import com.baidu.cloud.starlight.serialization.serializer.JsonSerializer;
import com.baidu.cloud.starlight.springcloud.common.ApplicationContextUtils;
import com.baidu.cloud.starlight.springcloud.server.properties.StarlightServerProperties;
import com.baidu.cloud.thirdparty.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

public abstract class StarlightRegisterListener
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarlightRegisterListener.class);
    protected ServiceRegistry serviceRegistry;
    protected ApplicationContext applicationContext;
    protected Registration registration;
    protected StarlightServerProperties serverProperties;
    protected static final String RPC_TYPE = "rpc";
    private final ExecutorService registerExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("StarlightRegisterWorker"));

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.applicationContext = event.getApplicationContext();
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean(ServiceRegistry.class);
        this.serverProperties = (StarlightServerProperties)this.applicationContext.getBean(StarlightServerProperties.class);
        Integer registerDelay = this.serverProperties.getRegisterDelay();
        if (registerDelay != null && registerDelay > 0) {
            try {
                TimeUnit.SECONDS.sleep(registerDelay.intValue());
            }
            catch (InterruptedException e) {
                LOGGER.warn("Exception occur when delay before register, cause by {}", (Object)e.getMessage());
            }
        }
        this.registration = this.createStarlightRegistration();
        this.registerExecutor.execute(() -> {
            try {
                LOGGER.info("Register starlight server instance {}:{} start", (Object)(this.registration.getHost() == null ? NetUriUtils.getLocalHost() : this.registration.getHost()), (Object)this.registration.getPort());
                this.serviceRegistry.register(this.registration);
                LOGGER.info("Register starlight server instance {}:{} success", (Object)(this.registration.getHost() == null ? NetUriUtils.getLocalHost() : this.registration.getHost()), (Object)this.registration.getPort());
            }
            catch (Throwable e) {
                LOGGER.warn("Register server instance {}:{} failed, cause by ", new Object[]{this.registration.getHost(), this.registration.getPort(), e});
            }
        });
    }

    protected abstract Registration createStarlightRegistration();

    protected String getAppName(Environment env) {
        return ApplicationContextUtils.getApplicationName();
    }

    protected Integer getPort(Environment env) {
        return ApplicationContextUtils.getServerPort();
    }

    protected String getInstanceId(Environment env) {
        String appName = this.getAppName(env);
        Integer port = this.getPort(env);
        String instanceId = "instanceId";
        return String.format("%s-%s-%s-rpc", appName, port, instanceId);
    }

    protected List<String> getInterfaces() {
        LinkedList<String> interfaces = new LinkedList<String>();
        Set serviceInvokers = RpcServiceRegistry.getInstance().rpcServices();
        if (serviceInvokers != null) {
            for (ServiceInvoker invoker : serviceInvokers) {
                if (invoker.getRpcService().getServiceClass() == HeartbeatService.class) continue;
                interfaces.add(invoker.getRpcService().getServiceClass().getName());
            }
        }
        return interfaces;
    }

    public void deRegister() {
        if (this.registration != null) {
            this.registerExecutor.execute(() -> {
                try {
                    LOGGER.info("Deregister server instance {}:{} start", (Object)this.registration.getHost(), (Object)this.registration.getPort());
                    this.serviceRegistry.deregister(this.registration);
                    LOGGER.info("Deregister server instance {}:{} success", (Object)this.registration.getHost(), (Object)this.registration.getPort());
                }
                catch (Exception e) {
                    LOGGER.warn("Deregister server instance failed, cause by: ", (Throwable)e);
                }
            });
        }
    }

    protected Map<String, String> starlightMetas() {
        HashMap<String, String> starlightMetas = new HashMap<String, String>();
        String protocols = ((StarlightServerProperties)this.applicationContext.getBean(StarlightServerProperties.class)).getProtocols();
        starlightMetas.put("protocols", protocols);
        try {
            List<String> interfaces = this.getInterfaces();
            starlightMetas.put("interfaces", JsonSerializer.OBJECT_MAPPER.writeValueAsString(interfaces));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Add interfaces to register meta failed.", e);
        }
        starlightMetas.put("EPOCH", String.valueOf(System.currentTimeMillis()));
        return starlightMetas;
    }

    public void destroy() {
        LOGGER.info("Shutdown the Executor pool for StarlightRegisterListener");
        this.registerExecutor.shutdown();
    }
}

