/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.shutdown;

import com.baidu.cloud.starlight.api.rpc.StarlightServer;
import com.baidu.cloud.starlight.springcloud.server.register.StarlightRegisterListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

public class StarlightGracefullyShutdownLifecycle
implements SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarlightGracefullyShutdownLifecycle.class);
    private volatile boolean running = false;
    private final StarlightServer starlightServer;
    private final StarlightRegisterListener registerListener;

    public StarlightGracefullyShutdownLifecycle(StarlightServer starlightServer, StarlightRegisterListener registerListener) {
        this.starlightServer = starlightServer;
        this.registerListener = registerListener;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.registerListener.deRegister();
        this.starlightServer.destroy();
        callback.run();
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        throw new UnsupportedOperationException("Stop must not be invoked directly");
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0x7FFFFFF5;
    }
}

