/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.extension;

import com.baidu.cloud.starlight.api.extension.ClassLoadContext;
import com.baidu.cloud.starlight.api.extension.IClassLoadStrategy;

public class DefaultClassLoadStrategy
implements IClassLoadStrategy {
    @Override
    public ClassLoader getClassLoader(ClassLoadContext ctx) {
        ClassLoader systemLoader;
        if (ctx == null) {
            throw new IllegalArgumentException("null input: ctx");
        }
        ClassLoader callerLoader = ctx.getCallerClass().getClassLoader();
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader result = DefaultClassLoadStrategy.isChild(contextLoader, callerLoader) ? callerLoader : (DefaultClassLoadStrategy.isChild(callerLoader, contextLoader) ? contextLoader : contextLoader);
        if (DefaultClassLoadStrategy.isChild(result, systemLoader = ClassLoader.getSystemClassLoader())) {
            result = systemLoader;
        }
        return result;
    }

    private static boolean isChild(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 == loader2) {
            return true;
        }
        if (loader2 == null) {
            return false;
        }
        if (loader1 == null) {
            return true;
        }
        while (loader2 != null) {
            if (loader2 == loader1) {
                return true;
            }
            loader2 = loader2.getParent();
        }
        return false;
    }
}

