/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.protocol;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.utils.LogUtils;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ProtocolEncoder {
    public static final Logger LOGGER = LoggerFactory.getLogger(ProtocolEncoder.class);

    public ByteBuf encode(MsgBase var1) throws CodecException;

    public void encodeBody(MsgBase var1) throws CodecException;

    default public void addAdditionalRespKv(Response response) {
        Map<String, Object> respExtKv = response.getAttachmentKv();
        try {
            if (response.getRequest() != null) {
                Request request = response.getRequest();
                Long recvReqTime = request.getNoneAdditionKv().get("receive_byte_msg_time") == null ? null : (Long)request.getNoneAdditionKv().get("receive_byte_msg_time");
                Long retRespTime = response.getNoneAdditionKv().get("before_encode_header_time") == null ? null : (Long)response.getNoneAdditionKv().get("before_encode_header_time");
                Long serverExecCost = null;
                if (recvReqTime != null && retRespTime != null) {
                    serverExecCost = retRespTime - recvReqTime;
                }
                Long executeMethodCost = request.getNoneAdditionKv().get("execute_method_cost") == null ? null : (Long)request.getNoneAdditionKv().get("execute_method_cost");
                Map<String, String> tidSpid = LogUtils.parseTraceIdSpanId(request);
                respExtKv.put("serv_recv_req_time", recvReqTime);
                respExtKv.put("serv_exec_cost", serverExecCost);
                respExtKv.put("execute_method_cost", executeMethodCost);
                respExtKv.put("trace.id", tidSpid.get("tcid"));
                respExtKv.put("request_timeout", request.getAttachmentKv().get("request_timeout"));
                respExtKv.put("before_encode_header_time", request.getAttachmentKv().get("before_encode_header_time"));
            }
        }
        catch (Throwable e) {
            LOGGER.warn("generateStarlightRespMeta from response failed, cause by ", e);
        }
    }
}

