/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.rpc;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.Map;

public class RpcContext {
    public static final String REMOTE_HOST_KEY = "remoteHost";
    public static final String REMOTE_PORT_KEY = "remotePort";
    public static final String PARMS_KEY = "parmeters";
    public static final String PARMTYPES_KEY = "parameterTypes";
    public static final String METHODNAME_KEY = "methodName";
    private static final ThreadLocal<RpcContext> RPC_CONTEXT = ThreadLocal.withInitial(RpcContext::new);
    private Map<String, Object> values = new LinkedHashMap<String, Object>();
    private Integer requestTimeoutMills;
    private String remoteHost;
    private Integer remotePort;

    public static RpcContext getContext() {
        return RPC_CONTEXT.get();
    }

    public static void removeContext() {
        RPC_CONTEXT.remove();
    }

    public Map<String, Object> get() {
        return this.values;
    }

    public <T> T get(String key) {
        return (T)this.values.get(key);
    }

    public RpcContext set(String key, Object value) {
        this.values.put(key, value);
        return this;
    }

    public RpcContext set(Map<String, Object> values) {
        this.values.clear();
        if (values != null && values.size() > 0) {
            this.values.putAll(values);
        }
        return this;
    }

    public RpcContext remove(String key) {
        this.values.remove(key);
        return this;
    }

    public String getSessionID() {
        return (String)this.get("session.id");
    }

    public void setSessionID(String sessionID) {
        this.set("session.id", sessionID);
    }

    public String getRequestID() {
        return (String)this.get("request.id");
    }

    public void setRequestID(String requestID) {
        this.set("request.id", requestID);
    }

    public void setRequestTimeoutMills(Integer requestTimeoutMills) {
        this.requestTimeoutMills = requestTimeoutMills;
    }

    public Integer getRequestTimeoutMills() {
        return this.requestTimeoutMills;
    }

    public RpcContext setRemoteAddress(String host, int port) {
        if (port < 0) {
            port = 0;
        }
        this.setRemoteHost(host);
        this.setRemotePort(port);
        return this;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemotePort(Integer remotePort) {
        this.remotePort = remotePort;
    }

    public String getRemoteAddressString() {
        return this.getRemoteHostName() + ":" + this.getRemotePort();
    }

    public String getRemoteHostName() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort == null ? 0 : this.remotePort;
    }

    public HttpServletRequest getServletRequest() {
        return (HttpServletRequest)this.get("http_servlet_request");
    }

    public HttpServletResponse getServletResponse() {
        return (HttpServletResponse)this.get("http_servlet_response");
    }
}

